% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_parsers.R
\name{parse_victornivo}
\alias{parse_victornivo}
\title{Extract relevant data from a raw data export file generated from the software of Perkin Elmer's "Victor Nivo" plate readers.}
\usage{
parse_victornivo(input)
}
\arguments{
\item{input}{A dataframe created by reading a table file with \code{\link{read_file}}}
}
\value{
a list of length two containing growth and/or fluorescence dataframes in the first and second element, respectively. The first column in these dataframes represents a time vector.
}
\description{
Extract relevant data from a raw data export file generated from the software of Perkin Elmer's "Victor Nivo" plate readers.
}
\examples{
if(interactive()){
input <- read_file(filename = system.file("nivo_output.csv", package = "QurvE"), csvsep = "," )
parsed <- parse_victornivo(input)
}
}
