% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth_summaries.R
\name{summary.drFitModel}
\alias{summary.drFitModel}
\title{Generic summary function for drFitModel objects}
\usage{
\method{summary}{drFitModel}(object, ...)
}
\arguments{
\item{object}{object of class \code{drFitModel}}

\item{...}{Additional arguments. This has currently no effect and is only meant to fulfill the requirements of a generic function.}
}
\value{
A dataframe with parameters extracted from the dose-response analysis of a single sample.
}
\description{
Generic summary function for drFitModel objects
}
\examples{
conc <- c(0, rev(unlist(lapply(1:18, function(x) 10*(2/3)^x))),10)
response <- c(1/(1+exp(-0.7*(4-conc[-20])))+rnorm(19)/50, 0)

TestRun <- growth.drFitModel(conc, response, drID = 'test')

print(summary(TestRun))

}
