% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countSwitches.R
\name{countSwitches}
\alias{countSwitches}
\title{create an incremented Counter, based on Start/Stop Markers}
\usage{
countSwitches(
  data,
  colNm,
  sttMark,
  endMark,
  includeStt = TRUE,
  includeEnd = TRUE
)
}
\arguments{
\item{data}{A data frame containing the column to process.}

\item{colNm}{A string specifying the column name in `data` to evaluate.}

\item{sttMark}{A value indicating the start of a series.}

\item{endMark}{A value indicating the end of a series.}

\item{includeStt}{Logical. Should the start marker be included as part of
the series? Default is `TRUE`.}

\item{includeEnd}{Logical. Should the end marker be included as part of the
series? Default is `TRUE`.}
}
\value{
A modified version of the input data frame with additional columns including:
\itemize{
  \item `catLvl`: The current series level calculated as the difference between the cumulative counts of start and end markers.
  \item `lvl_1`, `lvl_2`, `lvl_3`: Final series counts returned for each respective level.
}
}
\description{
This function aims at identifying sections and sub-sections
numbers, based on markers of section starts and ends.

Given a data frame, and the name of a column giving the start/stop markers,
it will add columns giving infos about the successive section levels
}
\note{
This function is currently mostly useful internally, to perform foldAllBr().
}
\examples{
# example code
library(dplyr)
tribble(
~step
, "start"
, "content of section 1"
, "start"
, "subsection 1.1"
, "end"
, "end"
, "out of any section"
, "start"
, "section 2"
, "start"
, "subsection 2.1"
, "end"
, "start"
, "subsection 2.2"
, "end"
, "end"
) \%>\%
	countSwitches(colNm = "step", "start", "end")

}
