% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Household.R
\name{Household}
\alias{Household}
\title{Household class}
\value{
An object of class \code{Household}.
}
\description{
The \code{Household} class aggregates information about
a household and its members.
}
\examples{
household <- Household$new()
household$risk_tolerance
household$consumption_impatience_preference
household$smooth_consumption_preference
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{expected_income}}{Set of rules that are used to
generate streams of expected income}

\item{\code{expected_spending}}{Set of rules that are used to
generate streams of expected spending}

\item{\code{risk_tolerance}}{Risk tolerance of the household}

\item{\code{consumption_impatience_preference}}{Consumption
impatience preference of the household -
subjective discount rate (rho).
Higher values indicate a stronger preference for consumption today
versus in the future.}

\item{\code{smooth_consumption_preference}}{Smooth consumption
preference of the household -
Elasticity of Intertemporal Substitution (EOIS) (eta).
Higher values indicate more flexibility and a lower preference
for smooth consumption.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Household-get_members}{\code{Household$get_members()}}
\item \href{#method-Household-add_member}{\code{Household$add_member()}}
\item \href{#method-Household-set_member}{\code{Household$set_member()}}
\item \href{#method-Household-set_lifespan}{\code{Household$set_lifespan()}}
\item \href{#method-Household-get_lifespan}{\code{Household$get_lifespan()}}
\item \href{#method-Household-calc_survival}{\code{Household$calc_survival()}}
\item \href{#method-Household-get_min_age}{\code{Household$get_min_age()}}
\item \href{#method-Household-clone}{\code{Household$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Household-get_members"></a>}}
\if{latex}{\out{\hypertarget{method-Household-get_members}{}}}
\subsection{Method \code{get_members()}}{
Getting members of the household
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Household$get_members()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Household-add_member"></a>}}
\if{latex}{\out{\hypertarget{method-Household-add_member}{}}}
\subsection{Method \code{add_member()}}{
Adding a member to the household
It will fail if a member with the same name already exists.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Household$add_member(household_member)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{household_member}}{A \code{HouseholdMember} object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Household-set_member"></a>}}
\if{latex}{\out{\hypertarget{method-Household-set_member}{}}}
\subsection{Method \code{set_member()}}{
Setting a member of the household
If a member already exists, it will be overwritten.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Household$set_member(member)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{member}}{A \code{HouseholdMember} object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Household-set_lifespan"></a>}}
\if{latex}{\out{\hypertarget{method-Household-set_lifespan}{}}}
\subsection{Method \code{set_lifespan()}}{
Setting an arbitrary lifespan of the household
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Household$set_lifespan(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A number of years.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Household-get_lifespan"></a>}}
\if{latex}{\out{\hypertarget{method-Household-get_lifespan}{}}}
\subsection{Method \code{get_lifespan()}}{
Getting a lifespan of the household
If not set, it will be calculated based on the members' lifespans.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Household$get_lifespan(current_date = get_current_date())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{current_date}}{A date in the format "YYYY-MM-DD".}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Household-calc_survival"></a>}}
\if{latex}{\out{\hypertarget{method-Household-calc_survival}{}}}
\subsection{Method \code{calc_survival()}}{
Calculating a survival rate of the household
based on its members' parameters of the Gompertz model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Household$calc_survival(current_date = get_current_date())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{current_date}}{A date in the format "YYYY-MM-DD".}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Household-get_min_age"></a>}}
\if{latex}{\out{\hypertarget{method-Household-get_min_age}{}}}
\subsection{Method \code{get_min_age()}}{
Calculating a minimum age of the household members.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Household$get_min_age(current_date = get_current_date())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{current_date}}{A date in the format "YYYY-MM-DD".}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Household-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Household-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Household$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
