% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_logical.R
\name{as_logical}
\alias{as_logical}
\alias{as_logical.data.frame}
\alias{as_logical.default}
\title{Interpret specific binary values as logicals}
\usage{
as_logical(
  x,
  values = list(c("TRUE", "FALSE"), c("Yes", "No"), c(1, 0), c(1, 2)),
  ...
)

\method{as_logical}{data.frame}(
  x,
  values = list(c("TRUE", "FALSE"), c("Yes", "No"), c(1, 0), c(1, 2)),
  ...
)

\method{as_logical}{default}(
  x,
  values = list(c("TRUE", "FALSE"), c("Yes", "No"), c(1, 0), c(1, 2)),
  ...
)
}
\arguments{
\item{x}{vector or data.frame}

\item{values}{list of values to interpret as logicals. First value is}

\item{...}{ignored
interpreted as TRUE.}
}
\value{
vector
}
\description{
Interpret specific binary values as logicals
}
\examples{
c(sample(c("TRUE", "FALSE"), 20, TRUE), NA) |>
  as_logical() |>
  class()
ds <- dplyr::tibble(
  B = factor(sample(c(1, 2), 20, TRUE)),
  A = factor(sample(c("TRUE", "FALSE"), 20, TRUE)),
  C = sample(c(3, 4), 20, TRUE),
  D = factor(sample(c("In", "Out"), 20, TRUE))
)
ds |>
  as_logical() |>
  sapply(class)
ds$A |> class()
sample(c("TRUE",NA), 20, TRUE) |>
  as_logical()
as_logical(0)
}
