// Copyright (c) 2020 GeometryFactory SARL (France).
// All rights reserved.
//
// This file is part of CGAL (www.cgal.org).
//
// $URL: https://github.com/CGAL/cgal/blob/v6.0.1/Shape_detection/include/CGAL/Shape_detection/Region_growing/Segment_set.h $
// $Id: include/CGAL/Shape_detection/Region_growing/Segment_set.h 50cfbde3b84 $
// SPDX-License-Identifier: GPL-3.0-or-later OR LicenseRef-Commercial
//
//
// Author(s)     : Dmitry Anisimov
//

#ifndef CGAL_SHAPE_DETECTION_REGION_GROWING_SEGMENT_SET_H
#define CGAL_SHAPE_DETECTION_REGION_GROWING_SEGMENT_SET_H

/// \cond SKIP_IN_MANUAL
#include <CGAL/license/Shape_detection.h>
/// \endcond

/**
* \ingroup PkgShapeDetectionRef
* \file CGAL/Shape_detection/Region_growing/Segment_set.h
* A convenience header that includes all classes related to the region growing algorithm on a segment set.
*/

#include <CGAL/Shape_detection/Region_growing/Segment_set/Least_squares_line_fit_region.h>
#include <CGAL/Shape_detection/Region_growing/Segment_set/Least_squares_line_fit_sorting.h>

#endif // CGAL_SHAPE_DETECTION_REGION_GROWING_SEGMENT_SET_H

