# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

initHMM <- function(n, m) {
    .Call('initHMM', n, m, PACKAGE = 'RcppHMM')
}

initPHMM <- function(n) {
    .Call('initPHMM', n, PACKAGE = 'RcppHMM')
}

initGHMM <- function(n, m = 1) {
    .Call('initGHMM', n, m, PACKAGE = 'RcppHMM')
}

verifyModel <- function(model) {
    .Call('verifyModel',model, PACKAGE = 'RcppHMM')
}

setNames <- function(hmm, names) {
    .Call('setNames', hmm, names, PACKAGE = 'RcppHMM')
}

setParameters <- function(hmm, params) {
    .Call('setParameters', hmm, params, PACKAGE = 'RcppHMM')
}

evaluation <- function(hmm, sequence, method = 'f') {
    .Call('evaluation', hmm, sequence, method, PACKAGE = 'RcppHMM')
}

viterbi <- function(hmm, sequence) {
    .Call('viterbi', hmm, sequence, PACKAGE = 'RcppHMM')
}

forwardBackward <- function(hmm, sequence) {
    .Call('forwardBackward', hmm, sequence, PACKAGE = 'RcppHMM')
}

loglikelihood <- function(hmm, sequences) {
    if(is.array(sequences) && length(dim(sequences)) == 3)  # Multivariate input
        .Call('loglikelihood', hmm, sequences, PACKAGE = 'RcppHMM')
    else if(is.matrix(sequences) && hmm$Model != "GHMM")
        .Call('loglikelihood', hmm, sequences, PACKAGE = 'RcppHMM')
    else
        .Call('evaluation', hmm, sequence = sequences, method = "f", PACKAGE = 'RcppHMM')    
}

learnEM <- function(hmm, sequences, iter = 100, delta = 1e-05, pseudo = 0, print = TRUE ){
    if(is.array(sequences) && length(dim(sequences)) == 3)  # Multivariate input
        .Call('learnEM', hmm, sequences, iter, delta, pseudo, print, PACKAGE = 'RcppHMM')
    else if(is.matrix(sequences) && hmm$Model != "GHMM")
        .Call('learnEM', hmm, sequences, iter, delta, pseudo, print, PACKAGE = 'RcppHMM')
    else
        .Call('learnBW', hmm, sequences, iter, delta, pseudo, print, PACKAGE = 'RcppHMM')
    
}

generateObservations <- function(hmm, length) {
    .Call('generateObservations', hmm, length, PACKAGE = 'RcppHMM')
}

