% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{set_default_binomial_priors}
\alias{set_default_binomial_priors}
\title{Set default prior distributions for binomial meta-analytic models}
\usage{
set_default_binomial_priors(parameter, null = FALSE, rescale = 1)
}
\arguments{
\item{parameter}{a character string specifying the parameter for
which the prior distribution should be set. Available options are
"effect", "heterogeneity", "baseline", "covariates",
"factors".}

\item{null}{a logical indicating whether the prior distribution
should be set for the null hypothesis. Defaults to \code{FALSE}.}

\item{rescale}{a numeric value specifying the re-scaling factor
for the default prior distributions. Defaults to 1. Allows
convenient re-scaling of prior distributions simultaneously.}
}
\value{
A prior distribution object or a list of prior distribution
objects.
}
\description{
Set default prior distributions for BiBMA models.
}
\details{
The default prior are based on the binary outcome meta-analyses
in the Cochrane Database of Systematic Reviews outlined in
\insertCite{bartos2023empirical;textual}{RoBMA}.

Specifically, the prior distributions are:

\strong{For the alternative hypothesis:}
\itemize{
\item \strong{Effect:} T distribution with mean 0, scale 0.58, and 4 degrees of freedom.
\item \strong{Heterogeneity:} Inverse gamma distribution with shape 1.77 and scale 0.55.
\item \strong{Baseline:} No prior distribution.
\item \strong{Standardized continuous covariates:} Normal distribution with mean 0 and standard deviation 0.29.
\item \strong{Factors (via by-level differences from the grand mean):} Normal distribution with mean 0 and standard deviation 0.29.
}

\strong{For the null hypothesis:}
\itemize{
\item \strong{Effect:} Point distribution at 0.
\item \strong{Heterogeneity:} Point distribution at 0.
\item \strong{Baseline:} Independent uniform distributions.
\item \strong{Standardized continuous covariates:} Point distribution at 0.
\item \strong{Factors (via by-level differences from the grand mean):} Point distribution at 0.
}

The rescaling factor adjusts the width of the effect, heterogeneity, covariates, factor, and PEESE-style model prior distributions.
PET-style and weight function prior distributions are scale-invariant.
}
\examples{

set_default_binomial_priors("effect")
set_default_binomial_priors("heterogeneity")
set_default_binomial_priors("baseline")

}
