% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viewAxis.R
\name{viewAxis}
\alias{viewAxis}
\alias{viewXY}
\alias{viewYZ}
\alias{viewZX}
\alias{viewAB}
\alias{viewBC}
\alias{viewCA}
\alias{viewInertia}
\title{Set the View of the \sQuote{rgl} Scene}
\usage{
viewAxis(V1, V2)

viewXY()

viewYZ()

viewZX()

viewAB(cryst1)

viewBC(cryst1)

viewCA(cryst1)

viewInertia(x, m = NULL)
}
\arguments{
\item{V1}{a length 3 numeric vector.}

\item{V2}{a length 3 numeric vector.}

\item{cryst1}{an object of class \sQuote{cryst1}.}

\item{x}{an R object containing atomic coordinates.}

\item{m}{a numeric vector containing atomic masses.}
}
\value{
No return value, called for side effects.
}
\description{
Set the view of the current \sQuote{rgl} scene aligning one vector 
perpendicularly to the screen and placing another one in the horizontal plane.
}
\details{
\code{viewAxis} set the view of the current rgl scene (by setting
\code{UserMatrix}; see \code{\link[rgl]{par3d}} for more details) so that
\code{V1} is perpendicular to the screen and \code{V2} is in the horizontal
plane. The other functions documented here are helper functions calling
\code{viewAxis} to set the view using particular Cartesian or lattice
vectors. For functions \code{viewAB}, \code{viewBC} and \code{viewCA} a
\sQuote{cryst1} object has to be specifyed to define the lattice vectors
used to set the view. The function \code{viewInertia} computes the inertia
tensor from the atomic coordinates and masses (see \code{\link{inertia}})
and sets the view to its eigen vectors basis set.
}
\examples{
x <- read.pdb(system.file("examples/PCBM_ODCB.pdb", package="Rpdb"))
visualize(x, mode = NULL)
viewAB(x$cryst1)

C70 <- read.pdb(system.file("examples/C70.pdb", package="Rpdb"))
visualize(C70, mode = NULL)
viewXY()
viewInertia(C70)

}
\seealso{
\code{\link{visualize}}, \code{\link{cell.coords}}, \code{\link[rgl]{par3d}}, \code{\link[rgl]{rgl.open}}
}
\keyword{dynamic}
