% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_fitting.R
\name{check_prior}
\alias{check_prior}
\title{Check prior parameters}
\usage{
check_prior(
  P_f,
  P_r,
  J,
  ordered = FALSE,
  eta = numeric(P_f),
  Psi = diag(P_f),
  delta = 1,
  xi = numeric(P_r),
  D = diag(P_r),
  nu = P_r + 2,
  Theta = diag(P_r),
  kappa = if (ordered) 4 else (J + 1),
  E = if (ordered) diag(1) else diag(J - 1),
  zeta = numeric(J - 2),
  Z = diag(J - 2)
)
}
\arguments{
\item{P_f}{The number of covariates connected to a fixed coefficient (can be 0).}

\item{P_r}{The number of covariates connected to a random coefficient (can be 0).}

\item{J}{The number (greater or equal 2) of choice alternatives.}

\item{ordered}{A boolean, \code{FALSE} per default. If \code{TRUE}, the choice set
\code{alternatives} is assumed to be ordered from worst to best.}

\item{eta}{The mean vector of length \code{P_f} of the normal prior for \code{alpha}.
Per default, \code{eta = numeric(P_f)}.}

\item{Psi}{The covariance matrix of dimension \code{P_f} x \code{P_f} of the normal prior for
\code{alpha}.
Per default, \code{Psi = diag(P_f)}.}

\item{delta}{A numeric for the concentration parameter vector \code{rep(delta,C)} of the
Dirichlet prior for \code{s}.
Per default, \code{delta = 1}. In case of Dirichlet process-based updates of the
latent classes, \code{delta = 0.1} per default.}

\item{xi}{The mean vector of length \code{P_r} of the normal prior for each \code{b_c}.
Per default, \code{xi = numeric(P_r)}.}

\item{D}{The covariance matrix of dimension \code{P_r} x \code{P_r} of the normal prior for
each \code{b_c}.
Per default, \code{D = diag(P_r)}.}

\item{nu}{The degrees of freedom (a natural number greater than \code{P_r}) of the Inverse
Wishart prior for each \code{Omega_c}.
Per default, \code{nu = P_r + 2}.}

\item{Theta}{The scale matrix of dimension \code{P_r} x \code{P_r} of the Inverse Wishart prior for
each \code{Omega_c}.
Per default, \code{Theta = diag(P_r)}.}

\item{kappa}{The degrees of freedom (a natural number greater than \code{J-1}) of the Inverse
Wishart prior for \code{Sigma}.
Per default, \code{kappa = J + 1}.}

\item{E}{The scale matrix of dimension \code{J-1} x \code{J-1} of the Inverse Wishart
prior for \code{Sigma}.
Per default, \code{E = diag(J - 1)}.}

\item{zeta}{The mean vector of length \code{J - 2} of the normal prior for the logarithmic
increments \code{d} of the utility thresholds in the ordered probit model.
Per default, \code{zeta = numeric(J - 2)}.}

\item{Z}{The covariance matrix of dimension \code{J-2} x \code{J-2} of the normal prior for the
logarithmic increments \code{d} of the utility thresholds in the ordered probit
model. Per default, \code{Z = diag(J - 2)}.}
}
\value{
An object of class \code{RprobitB_prior}, which is a list containing all
prior parameters. Parameters that are not relevant for the model
configuration are set to \code{NA}.
}
\description{
This function checks the compatibility of submitted parameters for the prior
distributions and sets missing values to default values.
}
\details{
A priori, we assume that the model parameters follow these distributions:
\itemize{
\item \eqn{\alpha \sim N(\eta, \Psi)}
\item \eqn{s \sim Dir(\delta)}
\item \eqn{b_c \sim N(\xi, D)} for all classes \eqn{c}
\item \eqn{\Omega_c \sim IW(\nu,\Theta)} for all classes \eqn{c}
\item \eqn{\Sigma \sim IW(\kappa,E)}
\item \eqn{d \sim N(\zeta, Z)}
}
where \eqn{N} denotes the normal, \eqn{Dir} the Dirichlet, and \eqn{IW}
the Inverted Wishart distribution.
}
\examples{
check_prior(P_f = 1, P_r = 2, J = 3, ordered = TRUE)
}
