% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edges.R
\name{redges}
\alias{redges}
\title{Simulate edges}
\usage{
redges(SBM, edgemod, sym = TRUE, loops = FALSE, ...)
}
\arguments{
\item{SBM}{an \code{\link{sbm}} object}

\item{edgemod}{an \code{\link{edgemod}} object}

\item{sym}{should the network be symmetric?}

\item{loops}{should the network have self-loops?}

\item{...}{additional arguments passed to \code{edgemod$r}}
}
\value{
an \code{edges} object
}
\description{
Simulate edges from an \code{\link{sbm}} object with a given \code{\link{edgemod}}
}
\details{
None
}
\examples{
## make an sbm model, sample data then plot and print:
model <- sbmmod(dma(2,5), param_beta(1,1,1,1), edges_bern())
s <- model$r(100)
e <- redges(s, model$edge)
plot(e)
plot(e, s)
print(e)
}
