% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unite.tbl_dbi.R
\name{unite.tbl_dbi}
\alias{unite.tbl_dbi}
\title{tidyr::unite for tbl_dbi}
\usage{
unite.tbl_dbi(data, col, ..., sep = "_", remove = TRUE, na.rm = FALSE)
}
\arguments{
\item{data}{A data frame.}

\item{col}{The name of the new column, as a string or symbol.

This argument is passed by expression and supports
\link[rlang:topic-inject]{quasiquotation} (you can unquote strings
and symbols). The name is captured from the expression with
\code{\link[rlang:defusing-advanced]{rlang::ensym()}} (note that this kind of interface where
symbols do not represent actual objects is now discouraged in the
tidyverse; we support it here for backward compatibility).}

\item{...}{<\code{\link[tidyr:tidyr_tidy_select]{tidy-select}}> Columns to unite}

\item{sep}{Separator to use between values.}

\item{remove}{If \code{TRUE}, remove input columns from output data frame.}

\item{na.rm}{If \code{TRUE}, missing values will be removed prior to uniting
each value.}
}
\value{
A tbl_dbi with the specified columns united into a new column named according to "col".
}
\description{
Convenience function to paste together multiple columns into one.
}
\examples{
\dontshow{if (Sys.info()["sysname"] != "Darwin") withAutoprint(\{ # examplesIf}
  library(tidyr, warn.conflicts = FALSE)

  df <- expand_grid(x = c("a", NA), y = c("b", NA))

  unite(df, "z", x:y, remove = FALSE)

  # To remove missing values:
  unite(df, "z", x:y, na.rm = TRUE, remove = FALSE)

  # Separate is almost the complement of unite
  unite(df, "xy", x:y) \%>\%
    separate(xy, c("x", "y"))
  # (but note `x` and `y` contain now "NA" not NA)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[tidyr:separate]{separate()}}, the complement.
}
