% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_EnrichmentHeatmap.R
\name{do_EnrichmentHeatmap}
\alias{do_EnrichmentHeatmap}
\title{Create enrichment scores heatmaps.}
\usage{
do_EnrichmentHeatmap(
  sample,
  input_gene_list,
  features.order = NULL,
  groups.order = NULL,
  cluster = TRUE,
  scale_scores = TRUE,
  assay = NULL,
  slot = NULL,
  reduction = NULL,
  group.by = NULL,
  verbose = FALSE,
  na.value = "grey75",
  legend.position = "bottom",
  use_viridis = FALSE,
  viridis.palette = "G",
  viridis.direction = 1,
  legend.framewidth = 0.5,
  legend.tickwidth = 0.5,
  legend.length = 20,
  legend.width = 1,
  legend.framecolor = "grey50",
  legend.tickcolor = "white",
  legend.type = "colorbar",
  font.size = 14,
  font.type = "sans",
  axis.text.x.angle = 45,
  enforce_symmetry = FALSE,
  nbin = 24,
  ctrl = 100,
  flavor = "Seurat",
  legend.title = NULL,
  ncores = 1,
  storeRanks = TRUE,
  min.cutoff = NA,
  max.cutoff = NA,
  pt.size = 1,
  plot_cell_borders = TRUE,
  border.size = 2,
  return_object = FALSE,
  number.breaks = 5,
  sequential.palette = "YlGnBu",
  diverging.palette = "RdBu",
  diverging.direction = -1,
  sequential.direction = 1,
  flip = FALSE,
  grid.color = "white",
  border.color = "black",
  plot.title.face = "bold",
  plot.subtitle.face = "plain",
  plot.caption.face = "italic",
  axis.title.face = "bold",
  axis.text.face = "plain",
  legend.title.face = "bold",
  legend.text.face = "plain"
)
}
\arguments{
\item{sample}{\strong{\code{\link[SeuratObject]{Seurat}}} | A Seurat object, generated by \link[Seurat]{CreateSeuratObject}.}

\item{input_gene_list}{\strong{\code{\link[SCpubr]{named_list}}} | Named list of lists of genes to be used as input.}

\item{features.order}{\strong{\code{\link[base]{character}}} | Should the gene sets be ordered in a specific way? Provide it as a vector of characters with the same names as the names of the gene sets.}

\item{groups.order}{\strong{\code{\link[SCpubr]{named_list}}} | Should the groups in theheatmaps be ordered in a specific way? Provide it as a named list (as many lists as values in \strong{\code{group.by}}) with the order for each of the elements in the groups.}

\item{cluster}{\strong{\code{\link[base]{logical}}} | Whether to perform clustering of rows and columns.}

\item{scale_scores}{\strong{\code{\link[base]{logical}}} | Whether to transform the scores to a range of 0-1 for plotting.}

\item{assay}{\strong{\code{\link[base]{character}}} | Assay to use. Defaults to the current assay.}

\item{slot}{\strong{\code{\link[base]{character}}} | Data slot to use. Only one of: counts, data, scale.data. Defaults to "data".}

\item{reduction}{\strong{\code{\link[base]{character}}} | Reduction to use. Can be the canonical ones such as "umap", "pca", or any custom ones, such as "diffusion". If you are unsure about which reductions you have, use \code{Seurat::Reductions(sample)}. Defaults to "umap" if present or to the last computed reduction if the argument is not provided.}

\item{group.by}{\strong{\code{\link[base]{character}}} | Metadata variable to group the output by. Has to be a character of factor column.}

\item{verbose}{\strong{\code{\link[base]{logical}}} | Whether to show extra comments, warnings,etc.}

\item{na.value}{\strong{\code{\link[base]{character}}} | Color value for NA.}

\item{legend.position}{\strong{\code{\link[base]{character}}} | Position of the legend in the plot. One of:
\itemize{
\item \emph{\code{top}}: Top of the figure.
\item \emph{\code{bottom}}: Bottom of the figure.
\item \emph{\code{left}}: Left of the figure.
\item \emph{\code{right}}: Right of the figure.
\item \emph{\code{none}}: No legend is displayed.
}}

\item{use_viridis}{\strong{\code{\link[base]{logical}}} | Whether to use viridis color scales.}

\item{viridis.palette}{\strong{\code{\link[base]{character}}} | A capital letter from A to H or the scale name as in \link[viridis]{scale_fill_viridis}.}

\item{viridis.direction}{\strong{\code{\link[base]{numeric}}} | Either 1 or -1. Controls how the gradient of viridis scale is formed.}

\item{legend.framewidth, legend.tickwidth}{\strong{\code{\link[base]{numeric}}} | Width of the lines of the box in the legend.}

\item{legend.length, legend.width}{\strong{\code{\link[base]{numeric}}} | Length and width of the legend. Will adjust automatically depending on legend side.}

\item{legend.framecolor}{\strong{\code{\link[base]{character}}} | Color of the lines of the box in the legend.}

\item{legend.tickcolor}{\strong{\code{\link[base]{character}}} | Color of the ticks of the box in the legend.}

\item{legend.type}{\strong{\code{\link[base]{character}}} | Type of legend to display. One of:
\itemize{
\item \emph{\code{normal}}: Default legend displayed by \pkg{ggplot2}.
\item \emph{\code{colorbar}}: Redefined colorbar legend, using \link[ggplot2]{guide_colorbar}.
}}

\item{font.size}{\strong{\code{\link[base]{numeric}}} | Overall font size of the plot. All plot elements will have a size relationship with this font size.}

\item{font.type}{\strong{\code{\link[base]{character}}} | Base font family for the plot. One of:
\itemize{
\item \emph{\code{mono}}: Mono spaced font.
\item \emph{\code{serif}}: Serif font family.
\item \emph{\code{sans}}: Default font family.
}}

\item{axis.text.x.angle}{\strong{\code{\link[base]{numeric}}} | Degree to rotate the X labels. One of: 0, 45, 90.}

\item{enforce_symmetry}{\strong{\code{\link[base]{logical}}} | Whether the geyser and feature plot has a symmetrical color scale.}

\item{nbin}{\strong{\code{\link[base]{numeric}}} | Number of bins to use in \link[Seurat]{AddModuleScore}.}

\item{ctrl}{\strong{\code{\link[base]{numeric}}} | Number of genes in the control set to use in \link[Seurat]{AddModuleScore}.}

\item{flavor}{\strong{\code{\link[base]{character}}} | One of: Seurat, UCell. Compute the enrichment scores using \link[Seurat]{AddModuleScore} or \link[UCell]{AddModuleScore_UCell}.}

\item{legend.title}{\strong{\code{\link[base]{character}}} | Title for the legend.}

\item{ncores}{\strong{\code{\link[base]{numeric}}} | Number of cores used to run UCell scoring.}

\item{storeRanks}{\strong{\code{\link[base]{logical}}} | Whether to store the ranks for faster UCell scoring computations. Might require large amounts of RAM.}

\item{min.cutoff, max.cutoff}{\strong{\code{\link[base]{numeric}}} | Set the min/max ends of the color scale. Any cell/group with a value lower than min.cutoff will turn into min.cutoff and any cell with a value higher than max.cutoff will turn into max.cutoff. In FeaturePlots, provide as many values as features. Use NAs to skip a feature.}

\item{pt.size}{\strong{\code{\link[base]{numeric}}} | Size of the dots.}

\item{plot_cell_borders}{\strong{\code{\link[base]{logical}}} | Whether to plot border around cells.}

\item{border.size}{\strong{\code{\link[base]{numeric}}} | Width of the border of the cells.}

\item{return_object}{\strong{\code{\link[base]{logical}}} | Return the Seurat object with the enrichment scores stored.}

\item{number.breaks}{\strong{\code{\link[base]{numeric}}} | Controls the number of breaks in continuous color scales of ggplot2-based plots.}

\item{sequential.palette}{\strong{\code{\link[base]{character}}} | Type of sequential color palette to use. Out of the sequential palettes defined in \strong{\code{\link[RColorBrewer]{brewer.pal}}}.}

\item{diverging.palette}{\strong{\code{\link[base]{character}}} | Type of symmetrical color palette to use. Out of the diverging palettes defined in \strong{\code{\link[RColorBrewer]{brewer.pal}}}.}

\item{diverging.direction}{\strong{\code{\link[base]{numeric}}} | Either 1 or -1. Direction of the divering palette. This basically flips the two ends.}

\item{sequential.direction}{\strong{\code{\link[base]{numeric}}} | Direction of the sequential color scale. Either 1 or -1.}

\item{flip}{\strong{\code{\link[base]{logical}}} | Whether to invert the axis of the displayed plot.}

\item{grid.color}{\strong{\code{\link[base]{character}}} | Color of the grid in the plot. In heatmaps, color of the border of the cells.}

\item{border.color}{\strong{\code{\link[base]{character}}} | Color for the border of the heatmap body.}

\item{plot.title.face, plot.subtitle.face, plot.caption.face, axis.title.face, axis.text.face, legend.title.face, legend.text.face}{\strong{\code{\link[base]{character}}} | Controls the style of the font for the corresponding theme element.  One of:
\itemize{
\item \emph{\code{plain}}: For normal text.
\item \emph{\code{italic}}: For text in itallic.
\item \emph{\code{bold}}: For text in bold.
\item \emph{\code{bold.italic}}: For text both in itallic and bold.
}}
}
\value{
A ggplot2 object.
}
\description{
This function computes the enrichment scores for the cells using \link[Seurat]{AddModuleScore} and then aggregates the scores by the metadata variables provided by the user and displays it as a heatmap, computed by \link[ComplexHeatmap]{Heatmap}.
}
\examples{
\donttest{
  # Check Suggests.
  value <- SCpubr:::check_suggests(function_name = "do_EnrichmentHeatmap", passive = TRUE)

  if (isTRUE(value)){
    # Consult the full documentation in https://enblacar.github.io/SCpubr-book/

    # Define your Seurat object.
    sample <- readRDS(system.file("extdata/seurat_dataset_example.rds", package = "SCpubr"))

    # Genes have to be unique.
    genes <- list("A" = rownames(sample)[1:5],
                  "B" = rownames(sample)[6:10],
                  "C" = rownames(sample)[11:15])

    # Default parameters.
    p <- SCpubr::do_EnrichmentHeatmap(sample = sample,
                                      input_gene_list = genes,
                                      nbin = 1,
                                      ctrl = 10)
    p

  } else if (base::isFALSE(value)){
    message("This function can not be used without its suggested packages.")
    message("Check out which ones are needed using `SCpubr::state_dependencies()`.")
  }
}
}
