% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparseness_funcs.R
\name{scatter.ratio}
\alias{scatter.ratio}
\title{Pixel scatteredness ratio.}
\usage{
scatter.ratio(im)
}
\arguments{
\item{im}{2-D numeric matrix representing the image pixel intensities.}
}
\value{
calculated scatter ratio.
}
\description{
\code{scatter.ratio} returns a measure of image scatteredness represented by
the ratio between the number of connected components and the total number of
non-zero pixels. The number of connected components is calculated from the
binarized image using Otsu's method.
}
\examples{
## Load package
library("SPUTNIK")

## Image
im <- matrix(rnorm(100), 10, 10)
im[im < 0] <- 0

## Spatial chaos
sc <- spatial.chaos(im, levels = 30, morph = TRUE)
stopifnot(sc <= 1)

## Gini index
gi <- gini.index(im, levels = 16)
stopifnot(gi >= -1 && gi <= 1)

## Scatter ratio
sr <- scatter.ratio(im)
stopifnot(sr <= 1)
}
\references{
Otsu, N. (1979). A threshold selection method from gray-level
histograms. IEEE transactions on systems, man, and cybernetics, 9(1), 62-66.
}
\seealso{
\link{gini.index} \link{spatial.chaos}
}
\author{
Paolo Inglese \email{p.inglese14@imperial.ac.uk}
}
