% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelstoch_additive.R
\name{modelstoch_additive}
\alias{modelstoch_additive}
\title{Chance Constrained Additive E-model.}
\usage{
modelstoch_additive(datadea,
               alpha = 0.05,
               dmu_eval = NULL,
               dmu_ref = NULL,
               orientation = NULL,
               weight_slack_i = 1,
               weight_slack_o = 1,
               rts = c("crs", "vrs", "nirs", "ndrs", "grs"),
               L = 1,
               U = 1,
               solver = c("alabama", "cccp", "cccp2", "slsqp"),
               give_X = TRUE,
               returnqp = FALSE,
               ...)
}
\arguments{
\item{datadea}{The data of class \code{deadata_stoch}, including \code{n} DMUs,
and the expected values of \code{m} inputs and \code{s} outputs.}

\item{alpha}{A value for parameter alpha.}

\item{dmu_eval}{A numeric vector containing which DMUs have to be evaluated.
If \code{NULL} (default), all DMUs are considered.}

\item{dmu_ref}{A numeric vector containing which DMUs are the evaluation reference set.
If \code{NULL} (default), all DMUs are considered.}

\item{orientation}{This parameter is either \code{NULL} (default) or a string, equal to
"io" (input-oriented) or "oo" (output-oriented). It is used to modify the weight slacks.
If input-oriented, \code{weight_slack_o} are taken 0.
If output-oriented, \code{weight_slack_i} are taken 0.}

\item{weight_slack_i}{A value, vector of length \code{m}, or matrix \code{m} x
\code{ne} (where \code{ne} is the length of \code{dmu_eval})
with the weights of the input slacks. If 0, output-oriented.}

\item{weight_slack_o}{A value, vector of length \code{s}, or matrix \code{s} x
\code{ne} (where \code{ne} is the length of \code{dmu_eval})
with the weights of the output slacks. If 0, input-oriented.}

\item{rts}{A string, determining the type of returns to scale, equal to "crs" (constant),
"vrs" (variable), "nirs" (non-increasing), "ndrs" (non-decreasing) or "grs" (generalized).}

\item{L}{Lower bound for the generalized returns to scale (grs).}

\item{U}{Upper bound for the generalized returns to scale (grs).}

\item{solver}{Character string with the name of the solver used by function \code{solvecop}
from package \code{optiSolve}.}

\item{give_X}{Logical. If it is \code{TRUE}, it uses an initial vector (given by
the evaluated DMU) for the solver, except for "cccp". If it is \code{FALSE},
the initial vector is given internally by the solver and it is usually
randomly generated.}

\item{returnqp}{Logical. If it is \code{TRUE}, it returns the quadratic
problems (objective function and constraints).}

\item{...}{Other parameters, like the initial vector \code{X}, to be passed
to the solver.}
}
\value{
A list with the results for the evaluated DMUs and other parameters
for reproducibility.
}
\description{
It solves the chance constrained additive E-model based on the
deterministic additive model from Charnes et al. (1985), under constant and
non-constant returns to scale.

Besides, the user can set weights for the input and/or output slacks. So, it
is also possible to solve chance constrained versions of weighted additive
models like Measure of Inefficiency Proportions (MIP) or Range Adjusted
Measure (RAM), see Cooper et al. (1999).

We consider \eqn{\mathcal{D}=\left\{ \textrm{DMU}_1, \ldots ,\textrm{DMU}_n \right\} }
a set of \eqn{n} DMUs with \eqn{m} stochastic inputs and \eqn{s} stochastic outputs.
Matrices \eqn{\tilde{X}=(\tilde{x}_{ij})} and \eqn{\tilde{Y}=(\tilde{y}_{rj})}
are the input and output data matrices, respectively, where \eqn{\tilde{x}_{ij}}
and \eqn{\tilde{y}_{rj}} represent the \eqn{i}-th input and \eqn{r}-th output
of the \eqn{j}-th DMU. Moreover, we denote by \eqn{X=(x_{ij})} and \eqn{Y=(y_{rj})}
their expected values. In general, we denote vectors by bold-face letters and
they are considered as column vectors unless otherwise stated. The \eqn{0}-vector
is denoted by \eqn{\bm{0}} and the context determines its dimension.

Given \eqn{0<\alpha <1}, the program for \eqn{\text{DMU}_o} with
constant returns to scale is given by
\deqn{\max \limits_{\bm{\lambda},\mathbf{s}^-,\mathbf{s}^+}\quad
\mathbf{w}^-\mathbf{s}^-+\mathbf{w}^+\mathbf{s}^+}
\deqn{\text{s.t.}\quad P\left\{ \left( \tilde{\mathbf{x}}_o-\tilde{X}
\bm{\lambda}-\mathbf{s}^-\right) _i\geq 0\right\}\geq 1-\alpha ,\qquad i=1,\ldots ,m,}
\deqn{P\left\{ \left( \tilde{Y}\bm{\lambda}-\tilde{\mathbf{y}}_o-\mathbf{s}^+\right) _r
\geq 0\right\}\geq 1-\alpha ,\qquad r=1,\ldots ,s,}
\deqn{\bm{\lambda}\geq \mathbf{0},\,\, \mathbf{s}^-\geq \mathbf{0},\,\,
\mathbf{s}^+\geq \mathbf{0},}
where \eqn{\bm{\lambda}=(\lambda_1,\ldots,\lambda_n)^\top}, \eqn{\tilde{\mathbf{x}}_o
=(\tilde{x}_{1o},\ldots,\tilde{x}_{mo})^\top} and \eqn{\tilde{\mathbf{y}}_o=
(\tilde{y}_{1o},\ldots,\tilde{y}_{so})^\top} are column vectors. Moreover,
\eqn{\mathbf{s}^-,\mathbf{s}^+} are column vectors with the slacks,
and \eqn{\mathbf{w}^-,\mathbf{w}^+} are positive row vectors with the weights
for the slacks.
Different returns to scale can be easily considered by adding the corresponding
constraints: \eqn{\mathbf{e}\bm{\lambda}=1} (VRS), \eqn{0\leq \mathbf{e}\bm{\lambda}
\leq 1} (NIRS), \eqn{\mathbf{e}\bm{\lambda}\geq 1} (NDRS) or \eqn{L\leq \mathbf{e}
\bm{\lambda}\leq U} (GRS), with \eqn{0\leq L\leq 1} and \eqn{U\geq 1}, where
\eqn{\mathbf{e}=(1,\ldots ,1)} is a row vector.

The deterministic equivalent for a multivariate normal distribution of inputs/outputs
is given by
\deqn{\max \limits_{\bm{\lambda},\mathbf{s}^-,\mathbf{s}^+}\quad \mathbf{w}^-
\mathbf{s}^-+\mathbf{w}^+\mathbf{s}^+ }
\deqn{\text{s.t.}\quad \mathbf{x}_o-X\bm{\lambda}-\mathbf{s}^-+\Phi ^{-1}(\alpha)
\bm{\sigma} ^-(\bm{\lambda})\geq \mathbf{0},}
\deqn{Y\bm{\lambda}-\mathbf{y}_o-\mathbf{s}^++\Phi ^{-1}(\alpha)\bm{\sigma}^+
(\bm{\lambda})\geq \mathbf{0},}
\deqn{\bm{\lambda}\geq \mathbf{0},\,\, \mathbf{s}^-\geq \mathbf{0},\,\,
\mathbf{s}^+\geq \mathbf{0},}
where \eqn{\Phi } is the standard normal distribution, and
\deqn{\displaystyle \left( \sigma ^-_i\left( \bm{\lambda}\right)\right) ^2 =
\sum _{j,q=1}^n\lambda _j\lambda _q\mathrm{Cov}(\tilde{x}_{ij},\tilde{x}_{iq})
-2\sum _{j=1}^n\lambda _j\mathrm{Cov}(\tilde{x}_{ij},\tilde{x}_{io})}
\deqn{+\mathrm{Var}(\tilde{x}_{io}),\quad i=1,\ldots ,m,}
\deqn{\displaystyle \left( \sigma ^+_r\left( \bm{\lambda}\right)\right) ^2 =
\sum _{j,q=1}^n\lambda _j\lambda _q\mathrm{Cov}(\tilde{y}_{rj},\tilde{y}_{rq})
-2\sum _{j=1}^n\lambda _j\mathrm{Cov}(\tilde{y}_{rj},\tilde{y}_{ro})}
\deqn{+\mathrm{Var}(\tilde{y}_{ro}),\quad r=1,\ldots ,s.}
}
\note{
A DMU is \eqn{\alpha}-stochastically efficient if and only if the optimal
objective value of the problem, (\code{objval}), is zero (or less than zero).
}
\references{
Charnes, A.; Cooper, W.W.; Golany, B.; Seiford, L.; Stuz, J. (1985) "Foundations
of Data Envelopment Analysis for Pareto-Koopmans Efficient Empirical Production
Functions", Journal of Econometrics, 30(1-2), 91-107.
\doi{10.1016/0304-4076(85)90133-2}

Cooper, W.W.; Park, K.S.; Pastor, J.T. (1999). "RAM: A Range Adjusted Measure
of Inefficiencies for Use with Additive Models, and Relations to Other Models
and Measures in DEA". Journal of Productivity Analysis, 11, p. 5-42.
\doi{10.1023/A:1007701304281}
}
\author{
\strong{Vicente Bolós} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

University of Valencia (Spain)
}
