% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sim.R
\name{plot_trend}
\alias{plot_trend}
\alias{plot_surface}
\alias{plot_grid}
\alias{plot_distribution}
\alias{plot_survey}
\alias{plot_total_strat_fan}
\alias{plot_length_strat_fan}
\alias{plot_age_strat_fan}
\alias{plot_error_surface}
\alias{plot_survey_rank}
\title{Simple plotting functions}
\usage{
plot_trend(sim, sum_ages = sim$ages, col = viridis::viridis(1), ...)

plot_surface(sim, mat = "N", xlab = "Age", ylab = "Year", zlab = mat, ...)

plot_grid(grid, ...)

plot_distribution(
  sim,
  ages = sim$ages,
  years = sim$years,
  type = "contour",
  scale = "natural",
  ...
)

plot_survey(sim, which_year = 1, which_sim = 1)

plot_total_strat_fan(sim, surveys = 1:5, quants = seq(90, 10, by = -10), ...)

plot_length_strat_fan(
  sim,
  surveys = 1:5,
  years = 1:10,
  lengths = 1:50,
  select_by = "year",
  quants = seq(90, 10, by = -10),
  ...
)

plot_age_strat_fan(
  sim,
  surveys = 1:5,
  years = 1:10,
  ages = 1:10,
  select_by = "year",
  quants = seq(90, 10, by = -10),
  ...
)

plot_error_surface(sim, plot_by = "rule")

plot_survey_rank(sim, which_strat = "age")
}
\arguments{
\item{sim}{Object returned by \code{\link[=sim_abundance]{sim_abundance()}}, \code{\link[=sim_distribution]{sim_distribution()}}, etc.}

\item{sum_ages}{Vector of ages to sum across.}

\item{col}{Plot color.}

\item{...}{Additional arguments passed to \code{\link[plotly:plot_ly]{plotly::plot_ly()}}.}

\item{mat}{Name of the matrix in the \code{sim} list to plot.}

\item{xlab, ylab, zlab}{Axis labels.}

\item{grid}{Grid produced by \code{\link[=make_grid]{make_grid()}}.}

\item{ages}{Subset the data to one or more ages.}

\item{years}{Subset the data to one or more years.}

\item{type}{Plot type: \code{"contour"} or \code{"heatmap"}.}

\item{scale}{Plot response on \code{"natural"} or \code{"log"} scale.}

\item{which_year}{Subset to a specific year.}

\item{which_sim}{Subset to a specific simulation replicate.}

\item{surveys}{Subset the data to one or more surveys.}

\item{quants}{Quantile intervals to display on the fan plot.}

\item{lengths}{Subset the data to one or more length groups.}

\item{select_by}{Select plot by \code{"age"}, \code{"length"}, or \code{"year"}.}

\item{plot_by}{Plot error surface by \code{"rule"} or \code{"samples"}.}

\item{which_strat}{Stratification focus: \code{"total"}, \code{"length"}, or \code{"age"}.}
}
\value{
A plot of class \code{plotly}.
}
\description{
These are simple plotting helpers to quickly visualize outputs from
\code{\link[=sim_abundance]{sim_abundance()}}, \code{\link[=sim_distribution]{sim_distribution()}}, and related simulation functions.
}
