% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_dist.R
\name{sim_parabola}
\alias{sim_parabola}
\title{Define a parabolic relationship}
\usage{
sim_parabola(
  alpha = 0,
  mu = 200,
  sigma = 70,
  sigma_right = NULL,
  log_space = FALSE,
  plot = FALSE
)
}
\arguments{
\item{alpha, mu, sigma}{Parameters that control the shape of the parabola. Can be a single value or
a vector of the same length as the number of ages in the simulation (e.g., allowing age-specific
depth associations).}

\item{sigma_right}{Optional parameter to impose asymmetry by specifying a different \code{sigma} for the right side.
If used, \code{sigma} defines the width of the left side. Ignored if \code{NULL}.}

\item{log_space}{Logical. Should the shape of the parabola be defined in log space?
If \code{TRUE}, parameters are assumed to be logged, and input \code{x} values are log-transformed.
This produces a lognormal-like curve with a heavier right tail and forces low values near zero.}

\item{plot}{Logical. Should a simple plot of the simulated values be produced?}
}
\value{
A function that can be passed to \code{\link[=sim_distribution]{sim_distribution()}}.
}
\description{
Closure to be used in \code{\link[=sim_distribution]{sim_distribution()}}. The form is based on the bi-Gaussian
function described in \doi{10.1186/1471-2105-11-559}.
}
\examples{
parabola_fun <- sim_parabola(mu = 50, sigma = 5, plot = TRUE)
parabola_fun(data.frame(depth = 0:100))

parabola_fun <- sim_parabola(mu = log(40), sigma = 0.5, log_space = FALSE, plot = TRUE)
parabola_fun(data.frame(depth = 0:100))

parabola_fun <- sim_parabola(mu = c(50, 120), sigma = c(5, 3), plot = TRUE)
parabola_fun(expand.grid(depth = 1:200, age = 1:2))

}
