% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Celltype_Annotation.R
\name{Celltype_Annotation}
\alias{Celltype_Annotation}
\title{Annotate Seurat Object with SlimR Cell Type Predictions}
\usage{
Celltype_Annotation(
  seurat_obj,
  cluster_col,
  SlimR_anno_result,
  plot_UMAP = TRUE,
  annotation_col = "Cell_type_SlimR"
)
}
\arguments{
\item{seurat_obj}{A Seurat object containing cluster information in meta.data.}

\item{cluster_col}{Character string indicating the column name in meta.data that
contains cluster IDs.}

\item{SlimR_anno_result}{List generated by function Celltype_Calculate() which
containing a data.frame in $Prediction_results with: 1.cluster_col (Cluster
identifiers (should match cluster_col in meta.data)) 2.Predicted_cell_type
(Predicted cell types for each cluster).}

\item{plot_UMAP}{logical(1); if TRUE, plot the UMAP with cell type annotations.}

\item{annotation_col}{The location to write in 'meta.data' that contains the
predicted cell type. (default = "Cell_type_SlimR")}
}
\value{
A Seurat object with updated meta.data containing the predicted cell types.
}
\description{
This function assigns SlimR predicted cell types to a Seurat object
based on cluster annotations, and stores the results in the meta.data slot.
}
\note{
If plot_UMAP = TRUE, this function will print a UMAP plot as a side effect.
}
\examples{
\dontrun{
sce <- Celltype_Annotation(seurat_obj = sce,
    cluster_col = "seurat_clusters",
    SlimR_anno_result = SlimR_anno_result,
    plot_UMAP = TRUE,
    annotation_col = "Cell_type_SlimR"
    )
    }

}
\seealso{
Other Automated_Annotation_Workflow: 
\code{\link{Celltype_Calculate}()},
\code{\link{Celltype_Verification}()}
}
\concept{Automated_Annotation_Workflow}
