% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameters.R
\name{set_parameters}
\alias{set_parameters}
\title{Set Packagewise Global Parameters for the Claims Simulator}
\usage{
set_parameters(ref_claim = 2e+05, time_unit = 1/4)
}
\arguments{
\item{ref_claim}{a reference value for the claim sizes (default 200000).}

\item{time_unit}{time unit to work with, given as a fraction of a year;
default calendar quarters (1/4).}
}
\description{
Sets \code{ref_claim} and \code{time_unit} parameters for all the simulation functions
within the \code{SynthETIC} package.
}
\details{
Those variables will be available to multiple functions in this
package, but are kept local to the package environment (i.e. not accessible
from the global environment). To extract the current values of the variables,
use \code{\link{return_parameters}}. \cr \cr
We introduce the reference value \code{ref_claim} partly as a measure of the
monetary unit and/or overall claims experience. The default distributional
assumptions were set up with an Australian Auto Liability portfolio in mind.
\code{ref_claim} then allows users to easily simulate a synthetic portfolio with
similar claim pattern but in a different currency, for example. We also
remark that users can alternatively choose to interpret \code{ref_claim} as a
monetary unit. For example, one can set \code{ref_claim <- 1000} and think of all
amounts in terms of $1,000. However, in this case the default simulation
functions will not work and users will need to supply their own set of
functions and set the values as multiples of \code{ref_claim} rather than
fractions as in the default setting. \cr \cr
We also require the user to input a \code{time_unit} (which should be given as a
fraction of year), so that the default input parameters apply to contexts
where the time units are no longer in quarters. In the default setting we
have a \code{time_unit} of 1/4 i.e. we work with calendar quarters. \cr \cr
The default input parameters will update automatically with the choice of
the two variables \code{ref_claim} and \code{time_unit}, which ensures that the
simulator produce sensible results in contexts other than the default
setting. We remark that both \code{ref_claim} and \code{time_unit} only affect the
default simulation functions, and users can also choose to set up their own
modelling assumptions for any of the modules to match their experiences even
better. In the latter case, it is the responsibility of the user to ensure
that their input parameters are compatible with their time units and claims
experience. For example, if the time units are quarters, then claim
occurrence rates must be quarterly.
}
\examples{
set_parameters(ref_claim = 200000, time_unit = 1/12) # monthly reserving
}
\seealso{
See the vignette for this package for a full list of functions
impacted by those two variables.
}
