% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subspace_LSR.R
\name{LSR}
\alias{LSR}
\title{Least Squares Regression}
\usage{
LSR(data, k = 2, lambda = 1e-05, zerodiag = TRUE)
}
\arguments{
\item{data}{an \eqn{(n\times p)} matrix of row-stacked observations.}

\item{k}{the number of clusters (default: 2).}

\item{lambda}{regularization parameter (default: 1e-5).}

\item{zerodiag}{a logical; \code{TRUE} (default) to use the problem formulation with zero 
diagonal entries or \code{FALSE} otherwise.}
}
\value{
a named list of S3 class \code{T4cluster} containing 
\describe{
\item{cluster}{a length-\eqn{n} vector of class labels (from \eqn{1:k}).} 
\item{algorithm}{name of the algorithm.}
}
}
\description{
For the subspace clustering, traditional method of least squares regression 
is used to build coefficient matrix that reconstructs the data point by solving 
\deqn{\textrm{min}_Z \|X-XZ\|_F^2 + \lambda \|Z\|_F \textrm{ such that }diag(Z)=0}
where \eqn{X\in\mathbf{R}^{p\times n}} is a column-stacked data matrix. 
As seen from the equation, we use a denoising version controlled by \eqn{\lambda} and 
provide an option to abide by the constraint \eqn{diag(Z)=0} by \code{zerodiag} parameter.
}
\examples{
\donttest{
## generate a toy example
set.seed(10)
tester = genLP(n=100, nl=2, np=1, iso.var=0.1)
data   = tester$data
label  = tester$class

## do PCA for data reduction
proj = base::eigen(stats::cov(data))$vectors[,1:2]
dat2 = data\%*\%proj

## run LSR for k=3 with different lambda values
out1 = LSR(data, k=3, lambda=1e-2)
out2 = LSR(data, k=3, lambda=1)
out3 = LSR(data, k=3, lambda=1e+2)

## extract label information
lab1 = out1$cluster
lab2 = out2$cluster
lab3 = out3$cluster

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(dat2, pch=19, cex=0.9, col=lab1, main="LSR:lambda=1e-2")
plot(dat2, pch=19, cex=0.9, col=lab2, main="LSR:lambda=1")
plot(dat2, pch=19, cex=0.9, col=lab3, main="LSR:lambda=1e+2")
par(opar)
}

}
\references{
\insertRef{hutchison_robust_2012}{T4cluster}
}
\concept{subspace}
