% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simTrees.r
\name{simTrees}
\alias{simTrees}
\title{simulating objects of class \code{tprTrees}}
\usage{
simTrees(par = NULL)
}
\arguments{
\item{par}{list of lists, one for each species}
}
\value{
an object of class \code{tprTrees}
}
\description{
Function to simulate an object of class \code{tprTrees}
}
\details{
Function simulates trees based on given distributions and petterson
height function. Dbh can be simulated using normal ('norm'), weibull or
gamma distribution. Others might be added.

The \code{par}-list of each species needs the following named entries:
\code{spp} - species code, \code{n} - number of trees, \code{ddist} -
distribution of dbh, \code{dpar} - list of parameter of the distribution,
i.e. \code{mu} and \code{sd} for normal distribution and \code{shape} and
\code{scale} for weibull and gamma distribution. The latter both might use
\code{lag} to offset the estimated diameter by this amount.
}
\examples{
par <- list(list(spp=1, n=10, ddist="norm", dpar=list(mu=30, sd=4)),
            list(spp=3, n=5, ddist="norm", dpar=list(mu=40, sd=2)))
simTrees(par)

}
\seealso{
\code{\link{petterson}} for the implemented height function and
\code{\link{dnorm}}, \code{\link{dweibull}} and \code{\link{dgamma}} for the
diameter distributions.
}
