% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SetRegion.R
\name{.SetRegion}
\alias{.SetRegion}
\title{Set plotting region}
\usage{
.SetRegion(region, prettify = NA_integer_, set = TRUE)
}
\arguments{
\item{region}{(optional) Named list of length two specifying the the
\code{min}imum and \code{max}imum values of each ternary axis to be drawn
(e.g. \verb{list(min = c(40, 0, 0), max = c(100, 60, 60)});
or a set of coordinates in a format accepted by \code{\link[=TernaryPoints]{TernaryPoints()}}.
The plotted region will correspond to the smallest equilateral triangle
that encompasses the specified ranges or coordinates.}

\item{prettify}{If numeric, the plotting region will be expanded to allow
grid lines to be produced with \code{pretty(n = prettify)}. If \code{NA}, the
smallest region encompassing \code{region} will be used.}

\item{set}{Logical specifying whether to set \code{options(ternRegion = region)}}
}
\value{
\code{.SetRegion()} returns the value of \code{options(ternRegion = region)}
if \code{set == TRUE}, or the region, otherwise..
}
\description{
Sets the region of the ternary plot being drawn.
Usually called from within \code{TernaryPlot()}; everyday users are unlikely to
need to call this function directly.
}
\examples{
# XY Coordinates under original plotting region
TernaryToXY(c(1, 2, 3))
previous <- .SetRegion(rbind(min = c(20, 20, 20), max = c(60, 60, 60)))

# New region options set
getOption("ternRegion")

# Coordinates under new plotting region
TernaryToXY(c(1, 2, 3))

# Restore previous setting
options(previous)
getOption("ternRegion")
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\keyword{internal}
