% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment-bootstrap-density.R
\name{bootstrap_density_augment}
\alias{bootstrap_density_augment}
\title{Bootstrap Density Tibble}
\usage{
bootstrap_density_augment(.data)
}
\arguments{
\item{.data}{The data that is passed from the \code{tidy_bootstrap()} or
\code{bootstrap_unnest_tbl()} functions.}
}
\value{
A tibble
}
\description{
Add density information to the output of \code{tidy_bootstrap()}, and
\code{bootstrap_unnest_tbl()}.
}
\details{
This function takes as input the output of the \code{tidy_bootstrap()} or
\code{bootstrap_unnest_tbl()} and returns an augmented tibble that has the following
columns added to it: \emph{\code{x}}, \emph{\code{y}}, \emph{\code{dx}}, and \emph{\code{dy}}.

It looks for an attribute that comes from using \code{tidy_bootstrap()} or
\code{bootstrap_unnest_tbl()} so it will not work unless the data comes from one of
those functions.
}
\examples{
x <- mtcars$mpg

tidy_bootstrap(x) |>
  bootstrap_density_augment()

tidy_bootstrap(x) |>
  bootstrap_unnest_tbl() |>
  bootstrap_density_augment()

}
\seealso{
Other Bootstrap: 
\code{\link{bootstrap_p_augment}()},
\code{\link{bootstrap_p_vec}()},
\code{\link{bootstrap_q_augment}()},
\code{\link{bootstrap_q_vec}()},
\code{\link{bootstrap_stat_plot}()},
\code{\link{bootstrap_unnest_tbl}()},
\code{\link{tidy_bootstrap}()}

Other Augment Function: 
\code{\link{bootstrap_p_augment}()},
\code{\link{bootstrap_q_augment}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Augment Function}
\concept{Bootstrap}
