% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10-helpers-spatial.R
\name{calculate_distances_vectorized}
\alias{calculate_distances_vectorized}
\title{Calculate vectorized distances to coastline}
\usage{
calculate_distances_vectorized(
  lon_point,
  lat_point,
  coast_lon,
  coast_lat,
  distance_type,
  window,
  unit,
  resolution = 0.25
)
}
\arguments{
\item{lon_point}{Vector of point longitudes.}

\item{lat_point}{Vector of point latitudes.}

\item{coast_lon}{Vector of coastline longitudes.}

\item{coast_lat}{Vector of coastline latitudes.}

\item{distance_type}{Distance calculation method.}

\item{window}{Spatial filter window in degrees.}

\item{unit}{Distance unit.}

\item{resolution}{Grid resolution (only used if distance_type = "grid").}
}
\value{
List with distance vectors and corresponding indices.
}
\description{
Internal function to calculate distances between multiple points and a coastline.
Supports different distance calculation methods and spatial filtering.
}
