% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/09-helpers-announcement.R
\name{validate_polygon_data}
\alias{validate_polygon_data}
\title{Validate data for polygon creation}
\usage{
validate_polygon_data(data)
}
\arguments{
\item{data}{Data frame to validate. Must contain polygon definition columns.}
}
\value{
Returns TRUE invisibly if validation passes, otherwise throws an error.
}
\description{
Validates that a data frame contains the necessary columns for creating
fishing zone polygons. Checks for either coordinate-based or distance-based
polygon definition data.
}
\details{
The function requires either:
\itemize{
\item Coordinate-based: StartLatitude, EndLatitude, StartLongitude, EndLongitude
\item Distance-based: StartLatitude, EndLatitude, StartNauticalMiles, EndNauticalMiles
}
}
\examples{
# Coordinate-based polygon data
coord_data <- data.frame(
  StartLatitude = "15 30 S",
  EndLatitude = "15 45 S", 
  StartLongitude = "75 30 W",
  EndLongitude = "75 45 W"
)
validate_polygon_data(coord_data)

# Distance-based polygon data  
distance_data <- data.frame(
  StartLatitude = "15 30 S",
  EndLatitude = "15 45 S",
  StartNauticalMiles = 5,
  EndNauticalMiles = 15
)
validate_polygon_data(distance_data)

}
