% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CircosFruits.R
\name{add_boxplot}
\alias{add_boxplot}
\title{Add a boxplot layer to a `ggtree` plot}
\usage{
add_boxplot(
  p,
  data,
  fill_color = "#f28131",
  alpha = 0.6,
  offset = 0.22,
  pwidth = 0.5
)
}
\arguments{
\item{p}{An existing ggtree plot object.}

\item{data}{A data frame containing the data to be plotted. Expected to have columns for 'Sample' and 'value'.}

\item{fill_color}{A character string specifying the fill color for the boxplots. Default is "#f28131".}

\item{alpha}{Numeric value for the transparency of the boxplots. Default is 0.6.}

\item{offset}{Numeric value, the position of the boxplot on the x-axis relative to its gene name. Default is 0.22.}

\item{pwidth}{Numeric value, the width of the boxplot. Default is 0.5.}
}
\value{
A `ggtree` plot object with the added boxplot layer.
}
\description{
This function adds a boxplot layer to an existing `ggtree` plot object using ggtreeExtra's geom_fruit for boxplots.
It is primarily used to display statistical summaries of the data related to gene expressions or other metrics.
}
\examples{
\donttest{
# Check and load required packages
if (requireNamespace("ggtreeExtra", quietly = TRUE) &&
 requireNamespace("ggplot2", quietly = TRUE)) {
  library(ggtreeExtra)
  library(ggplot2)

  file_path <- system.file("extdata", "p_tree_test.rds", package = "TransProR")
  p <- readRDS(file_path)

  # Create boxplot data frame
  boxplot_data <- data.frame(
    Sample = rep(c("Species_A", "Species_B", "Species_C", "Species_D"), each = 30),
    value = c(
      rnorm(30, mean = 5, sd = 1),   # Data for Species_A
      rnorm(30, mean = 7, sd = 1.5), # Data for Species_B
      rnorm(30, mean = 6, sd = 1.2), # Data for Species_C
      rnorm(30, mean = 8, sd = 1.3)  # Data for Species_D
    )
  )

  # Call add_boxplot function to add boxplot layer
  p_with_boxplot <- add_boxplot(p, boxplot_data)
} else {
  message("Required packages 'ggtreeExtra' and 'ggplot2' are not installed.")
}
}

}
