% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrepWilcoxon.R
\name{prep_wilcoxon}
\alias{prep_wilcoxon}
\title{Prepare Wilcoxon DEG data for plotting}
\usage{
prep_wilcoxon(input_path, output_name = NULL)
}
\arguments{
\item{input_path}{Path to the RDS file containing the Wilcoxon DEG data frame.}

\item{output_name}{Optional; name for the processed data frame, also used as the RDS file name.
If not provided, the data frame will not be saved to file.}
}
\value{
A data frame with processed Wilcoxon DEG data.
}
\description{
This function reads a Wilcoxon DEG data frame from an RDS file, filters it using
\code{\link{deg_filter}} function, adjusts the log2foldChange to absolute values, adds a pseudo-count to pValues,
and transforms pValues for plotting. The final data frame is returned and
optionally saved to a new RDS file.
}
\examples{
wilcoxon_file <- system.file("extdata",
                             "Wilcoxon_rank_sum_testoutRst_test.rds",
                             package = "TransProR")
Wilcoxon <- prep_wilcoxon(wilcoxon_file)

}
