% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportPatientLevel.R
\name{exportPatientLevel}
\alias{exportPatientLevel}
\title{exportPatientLevel}
\usage{
exportPatientLevel(andromeda, outputPath)
}
\arguments{
\item{andromeda}{(\code{Andromeda}) Andromeda object from \code{computePathways()}.}

\item{outputPath}{(\code{character(1)}) Directory where to write output files to.}
}
\value{
\code{NULL}
}
\description{
Exports patient-level files for custom data analysis.
}
\examples{
if (interactive()) {
  library(CDMConnector)
  library(DBI)
  library(TreatmentPatterns)

  con <- DBI::dbConnect(duckdb::duckdb(), dbdir = CDMConnector::eunomiaDir())
  cdm <- cdmFromCon(con, cdmSchema = "main", writeSchema = "main")

  cohortSet <- readCohortSet(
    path = system.file(package = "TreatmentPatterns", "exampleCohorts")
  )

  cdm <- generateCohortSet(
    cdm = cdm,
    cohortSet = cohortSet,
    name = "cohort_table"
  )

  cohorts <- cohortSet \%>\%
    # Remove 'cohort' and 'json' columns
    select(-"cohort", -"json") \%>\%
    mutate(type = c("event", "event", "event", "event", "exit", "event", "event", "target")) \%>\%
    rename(
      cohortId = "cohort_definition_id",
      cohortName = "cohort_name",
    ) \%>\%
    select("cohortId", "cohortName", "type")

  outputEnv <- computePathways(
    cohorts = cohorts,
    cohortTableName = "cohort_table",
    cdm = cdm
  )

  exportPatientLevel(outputEnv, tempdir())
}
}
