% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CorrelatedPfsAndOs3.R
\name{CorrelatedPfsAndOs3}
\alias{CorrelatedPfsAndOs3}
\title{Generate PFS and OS using the three-states model}
\usage{
CorrelatedPfsAndOs3(n, h01, h02, h12, pfs_name = "pfs", os_name = "os")
}
\arguments{
\item{n}{integer. Number of observations.}

\item{h01}{constant transition hazard from state "stable" to state "progression".}

\item{h02}{constant transition hazard from state "stable" to state "death".}

\item{h12}{constant transition hazard from state "progression" to state "death".}

\item{pfs_name}{column name of PFS in returned data frame. It must be
consistent with `name` in the function `endpoint()`.}

\item{os_name}{column name of OS in returned data frame. It must be
consistent with `name` in the function `endpoint()`.}
}
\value{
A data frame of four columns, including PFS, OS and their event indicators.
The event indicators are all 1s.
}
\description{
Generate PFS and OS using the three-states model
}
\examples{

pfs_and_os_trt <- CorrelatedPfsAndOs3(1e4, 0.06, 0.30, 0.30, 'PFS', 'OS')
pfs_and_os_pbo <- CorrelatedPfsAndOs3(1e4, 0.10, 0.40, 0.30, 'PFS', 'OS')

}
