% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StaggeredRecruiter.R
\name{StaggeredRecruiter}
\alias{StaggeredRecruiter}
\title{Generate enrollment time from piecewise constant uniform distribution}
\usage{
StaggeredRecruiter(n, accrual_rate)
}
\arguments{
\item{n}{number of random numbers}

\item{accrual_rate}{a data frame of columns
\code{end_time}:
    End time for a constant rate in a time window. The start time of
    the first time window is 0.
\code{piecewise_rate}:
    A constant rate in a time window. So the number of patients
    being recruited in that window is window length x \code{piecewise_rate}}
}
\description{
Accrual rate can be 10 patients/months for the first 2 months, 20 patients/
months for the second 2 months, and eventually 30 patients/months until the
end of trial.
}
\examples{
accrual_rate <- data.frame(
  end_time = c(12, 13:17, Inf),
  piecewise_rate = c(15, 15 + 6 * (1:5), 45)
)

accrual_rate <- data.frame(
  end_time = c(3, 4, 5, 8, Inf),
  piecewise_rate = c(1, 2, 2, 3, 4)
)

StaggeredRecruiter(30, accrual_rate)
}
