% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{GenLogEst}
\alias{GenLogEst}
\title{Generalised logistic distribution estimates from parameters}
\usage{
GenLogEst(loc, scale, shape, q = NULL, RP = 100)
}
\arguments{
\item{loc}{location parameter}

\item{scale}{scale parameter}

\item{shape}{shape parameter}

\item{q}{quantile. magnitude of the variable under consideration}

\item{RP}{return period}
}
\value{
quantile as a function of RP or vice versa
}
\description{
Estimated quantiles as function of return period (RP) and vice versa, from user input parameters
}
\details{
If the argument q is used, it overrides RP and provides RP as a function of q (magnitude of variable) as opposed to q as a function of RP.
}
\examples{
#Get an annual maximum sample, estimate the parameters and estimate 50-year RP
AM.27090 <- GetAM(27090)
GenLogPars(AM.27090$Flow)
#Store parameters in an object
Pars <- as.numeric(GenLogPars(AM.27090$Flow))
#get estimate of 50-yr flow
GenLogEst(Pars[1], Pars[2], Pars[3], RP = 50)
#Estimate the RP for a 600m3/s discharge
GenLogEst(Pars[1], Pars[2], Pars[3], q = 600)
}
\author{
Anthony Hammond
}
