% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.WCE.R
\name{summary.WCE}
\alias{summary.WCE}
\title{Summarize the results of a WCE object}
\usage{
\method{summary}{WCE}(object, allres = FALSE, ...)
}
\arguments{
\item{object}{A \code{WCE} object.}

\item{allres}{Logical. If TRUE, then a summary is produced for every model from the WCE object. If FALSE, then a summary is produced only for the best fitting model, as determined by AIC or BIC. Default to FALSE.}

\item{\dots}{Optional; other parameters to be passed through to \code{summary}.}
}
\value{
The \code{summary} method prints to screen the estimated coefficients, standard errors and p-values for the coefficients (if any) included in the WCE model. It also provides the partial likelihood and AIC or BIC value, and the number of events used in the estimation of the model.
}
\description{
This is a method to summarize the results from either the best fitting or all of the estimated models from a WCE object.
}
\examples{
wce <- WCE(drugdata, "Cox", 1, 90, constrained = "R", id = "Id", event = "Event",
start = "Start", stop = "Stop", expos = "dose", covariates = c("age", "sex"))
summary(wce)

}
\references{
Sylvestre, M. P., & Abrahamowicz, M. (2009). Flexible modeling of the cumulative effects of time-dependent exposures on the hazard. Statistics in medicine, 28(27), 3437-3453.
}
