% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_ctmm.R
\name{fit_ctmm}
\alias{fit_ctmm}
\title{Fit a continuous time movement model with \code{ctmm}}
\usage{
fit_ctmm(x, model, uere = NULL, ...)
}
\arguments{
\item{x}{\code{[track_xyt]} \cr A track created with \code{make_track} that includes time.}

\item{model}{\verb{[character(1)="bm"]\{"iid", "bm","ou","ouf", "auto"\}} \cr The autocorrelation model that should be fit to the data. \code{iid} corresponds to uncorrelated independent data, \code{bm} to Brownian motion, \code{ou} to an Ornstein-Uhlenbeck process, \code{ouf} to an Ornstein-Uhlenbeck forage process. \code{auto} will use model selection with AICc to find the best model.}

\item{uere}{User Equivalent Range Error, see \code{?ctmm::uere} for more details.}

\item{...}{Additional parameters passed to \code{ctmm::ctmm.fit} or \code{ctmm::ctmm.select} for \code{model = "auto"}}
}
\value{
An object of class \code{ctmm} from the package ctmm.
}
\description{
Fit a continuous time movement model with \code{ctmm}
}
\examples{
\donttest{
data(deer)
mini_deer <- deer[1:20, ]
m1 <- fit_ctmm(mini_deer, "iid")
summary(m1)
}
}
\references{
C. H. Fleming, J. M. Calabrese, T. Mueller, K.A. Olson, P. Leimgruber, W. F. Fagan, “From fine-scale foraging to home ranges: A semi-variance approach to identifying movement modes across spatiotemporal scales”, The American Naturalist, 183:5, E154-E167 (2014).
}
