% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleaning.R
\name{flag_defunct_clusters}
\alias{flag_defunct_clusters}
\alias{flag_defunct_clusters.track_xyt}
\title{Flag Defunct Clusters}
\usage{
flag_defunct_clusters(x, zeta, eta, theta, ...)

\method{flag_defunct_clusters}{track_xyt}(x, zeta, eta, theta, ...)
}
\arguments{
\item{x}{\verb{[track_xyt]} A \code{track_xyt} object.}

\item{zeta}{\verb{[numeric]} See details.}

\item{eta}{\verb{[numeric]} See details.}

\item{theta}{\verb{[numeric]} See details.}

\item{...}{Addtional arguments. None currently implemented.}
}
\value{
Returns \code{x} (a \code{track_xyt}) with a flagging column added
(\code{x$defunct_cluster_}).
}
\description{
Flags defunct clusters at the end of a track
}
\details{
Locations at the end of a trajectory may represent a dropped collar
or an animal mortality. In some cases, the device may be recording locations
for quite some time that are not biologically meaningful. This function
aims to flag those locations at the end of the trajectory that belong to a
mortality (or similar) cluster. The first location at the cluster remains
unflagged, but all subsequent locations are flagged.

The algorithm detects steps that represent zero movement, within a precision
threshold given by \code{zeta}. That is, if \code{zeta = 5} (units determined by CRS;
typically meters), all points that differ by less than 5 will be considered
zero movement. Consecutive steps of zero movement (within the tolerance) form
a cluster. The parameter \code{eta} gives the cutoff for the minimum number of
zero steps to be considered a cluster. Finally, the algorithm requires that
clusters persist without a non-zero step for a minimum amount of time, given
by \code{theta}.
}
\seealso{
\code{\link{flag_duplicates}()},
\code{\link{flag_fast_steps}()},
\code{\link{flag_roundtrips}()}
}
\author{
Brian J. Smith and Johannes Signer, based on code by Tal Avgar
}
