% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-uhc.R
\docType{data}
\name{uhc_issf_locs}
\alias{uhc_issf_locs}
\title{Simulated iSSF location data for demonstrating UHC plots}
\format{
A \code{data.frame} with 371 rows and 3 variables:
\describe{
\item{x}{x-coordinate in UTM Zone 12 (EPSG: 32612)}
\item{y}{Y-coordinate in UTM Zone 12 (EPSG: 32612)}
\item{t}{timestamp of location (timezone "US/Mountain")}
}

These data were simulated assuming an movement model, i.e., iSSA.

True movement-free habitat selection parameter values are:
\itemize{
\item \code{forage} = log(8)/500 (resource)
\item \code{temp^2} = -1 * log(8)/36 (condition; quadratic term)
\item \code{temp} = (log(8)/36) * 26 (condition; linear term)
\item \code{pred} = log(0.2)/5 (risk)
\item \code{cover == "forest"} = log(2) (grassland is intercept)
\item \code{cover == "wetland"} = log(1/2) (grassland is intercept)
\item \code{dist_to_cent} = -1 * log(10)/500 (keeps trajectory away from boundary)
}

Note: \code{temp} is modeled as a quadratic term, with the strongest selection
occurring at 13 °C and all other temperatures less selected.

Note: \code{dist_to_water} and \code{rand} have no real effect
on our animal's selection and are included for demonstration purposes.

True selection-free movement distributions are:
\itemize{
\item Step length: \code{gamma(shape = 3, scale = 25)}
\item Turn angle: \code{vonMises(mu = 0, kappa = 0.5)}
}
}
\usage{
uhc_issf_locs
}
\description{
Simulated iSSF location data for demonstrating UHC plots
}
\keyword{datasets}
