% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcci.R
\name{mcci}
\alias{mcci}
\title{Compute Monte Carlo Confidence Intervals}
\usage{
mcci(
  d1 = NULL,
  se1 = NULL,
  d2 = NULL,
  se2 = NULL,
  n.mcci = 10000,
  sig.level = 0.05,
  two.tailed = TRUE,
  eq.bd = NULL,
  xlim = NULL,
  xlab = NULL,
  ylab = NULL,
  dashed.lines = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{d1}{The estimated mean(s) (effect(s)) for group 1 (study 1).
If more than one effect is specified, it assumes that the effects are
 components of a mediation effect.}

\item{se1}{The estimated standard error for d1.
If more than one standard error is specified, it assumes that they are
 estimated components of a mediation effect.}

\item{d2}{The estimated mean(s) (effect(s)) for group 2 (study 2).
If more than one effect is specified, it assumes that the effects are
 components of a mediation effect.}

\item{se2}{The estimated standard error for d2.
If more than one standard error is specified, it assumes that they are
 estimated components of a mediation effect.}

\item{n.mcci}{The number of draws for the MCCI method. Default is 10,000.}

\item{sig.level}{The significance level. Default is .05.}

\item{two.tailed}{Logical of two tailed test for difference test. Default is TRUE.}

\item{eq.bd}{The limit of the equivalence bounds for an equivalence test.
Default is the MCCI for the equivalence test.
It can be specified in the arguments as eq.bd = a positive number or
eq.bd = c(lower bound #, upper bound #).}

\item{xlim}{The limits set for the x-axis in the plot.
Default is the MCCI for the difference test. It can be
 specified in the arguments as xlim = c(lower #, higher #).}

\item{xlab}{The label for the x-axis in the plot.
Default is "Differences in Effects".}

\item{ylab}{The label for the y-axis in the plot.
Default is NULL.}

\item{dashed.lines}{Logical of whether dashed lines of equivalence
bounds and zero should be added in the plot. Default is TRUE.}

\item{verbose}{Logical; print the process if TRUE,
otherwise not; default value is TRUE.}
}
\value{
The results of moderation analysis and equivalence tests
    using the MCCI method. It will also provide a plot for
    the MCCIs.
}
\description{
Compute Monte Carlo confidence intervals (MCCIs) for the
    difference and equivalence tests.
}
\examples{
   library(anomo)
   # compute MCCI from two studies
    myci <- mcci(d1 = .1, se1 = .1, d2 = .2, se2 = .1)
   # compute MCCI from one study
   myci <- mcci(d1 = .1, se1 = .1)

# See the package vignettes for more examples, including the MCCI for the
# test of significance and equivalence for mediation effects in two studies.

}
