% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fast_anticlustering.R
\name{generate_exchange_partners}
\alias{generate_exchange_partners}
\title{Get exchange partners for fast_anticlustering()}
\usage{
generate_exchange_partners(
  n_exchange_partners,
  N = NULL,
  features = NULL,
  method = "random",
  categories = NULL
)
}
\arguments{
\item{n_exchange_partners}{The number of exchange partners per
element}

\item{N}{The number of elements for which exchange partners; can be
\code{NULL} if \code{features} is passed (it is ignored if
\code{features} is passed).}

\item{features}{The features for which nearest neighbours are
sought if \code{method = "RANN"}.  May be NULL if random
exchange partners are generated.}

\item{method}{Currently supports "random" (default), "RANN" and
"restricted_random". See details.}

\item{categories}{A vector, data.frame or matrix representing one
or several categorical constraints.}
}
\value{
A list of length \code{N}. Is usually used as input to the
    argument \code{exchange_partners} in
    \code{\link{fast_anticlustering}}.  Then, the i'th element of
    the list contains the indices of the exchange partners that are
    used for the i'th element.
}
\description{
Get exchange partners for fast_anticlustering()
}
\details{
The \code{method = "RANN"} generates exchange partners using a
nearest neighbour search via \code{\link[RANN]{nn2}} from the
\code{RANN} package; \code{methode = "restricted_random"} generates
random exchange partners but ensures that for each element, no
duplicates are generated and that the element itself does not occur
as exchange partner (this is the slowest method, and I would not
recommend it for large N); \code{method = "random"} (default) does
not impose these restrictions and generates unrescricted random
partners (it may therefore generate duplicates and the element
itself as exchange partner).

When setting the \code{categories} argument and using \code{method
= "RANN"}, exchange partners (i.e., nearest neighbours) will be
generated from the same category; \code{methode =
"restricted_random"} will also adhere to categorical constraints
induced via \code{categories} (i.e. each element only receives
exchange partners from the same category as itself); \code{methode
= "random"} cannot incoorporate categorical restrictions.
}
\examples{

# Restricted random method generates no duplicates per element and cannot return 
# the element itself as exchange partner
generate_exchange_partners(5, N = 10, method = "restricted_random")
# "random" simply randomizes with replacement and without restrictions
# (categorical restrictions are also not possible; is much faster for large data sets)
generate_exchange_partners(5, N = 10, method = "random")
# May return less than 5 exchange partners if there are not enough members 
# of the same category: 
generate_exchange_partners(
  5, N = 10, 
  method = "restricted_random", 
  categories = cbind(schaper2019$room, schaper2019$frequency)
)
# using nearest neighbour search (unlike RANN::nn2, this does not 
# return the ID of the element itself as neighbour)
generate_exchange_partners(5, features = schaper2019[, 3:5], method = "RANN")[1:3]
# compare with RANN directly:
RANN::nn2(schaper2019[, 3:5], k = 6)$nn.idx[1:3, ] # note k = 6

}
