% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SoilProfileCollection.R,
%   R/SoilProfileCollection-setters.R
\docType{methods}
\name{horizons,SoilProfileCollection-method}
\alias{horizons,SoilProfileCollection-method}
\alias{horizons}
\alias{horizons<-}
\alias{horizons<-,SoilProfileCollection-method}
\title{Retrieve horizon data from SoilProfileCollection}
\usage{
\S4method{horizons}{SoilProfileCollection}(object)

\S4method{horizons}{SoilProfileCollection}(object) <- value
}
\arguments{
\item{object}{A SoilProfileCollection}

\item{value}{An object inheriting \code{data.frame}}
}
\description{
Get horizon data from SoilProfileCollection. Result is returned in the same \code{data.frame} class used to initially construct the SoilProfileCollection.

Horizon data in an object inheriting from \code{data.frame} can easily be added via merge (LEFT JOIN). There must be one or more same-named columns (with at least some matching data) on the left and right hand side to facilitate the join: \code{horizons(spc) <- newdata}
}
\examples{

# load test data
data(sp2)

# promote to SPC
depths(sp2) <- id ~ top + bottom

# assign true to surface horizon
newdata <- data.frame(top = 0,
                      newvalue = TRUE)

# do left join
horizons(sp2) <- newdata

# inspect site table: newvalue TRUE only for horizons
#  with top depth equal to zero
horizons(sp2)

}
