% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertAlgoPerfToWideFormat.R
\name{convertAlgoPerfToWideFormat}
\alias{convertAlgoPerfToWideFormat}
\title{Converts \code{algo.runs} object of a scenario to wide format.}
\usage{
convertAlgoPerfToWideFormat(desc, algo.runs, measure)
}
\arguments{
\item{desc}{[\code{\link{ASScenarioDesc}}]\cr
Description object of scenario.}

\item{algo.runs}{[\code{data.frame}]\cr
Algo runs data.frame from scenario.}

\item{measure}{[\code{character(1)}]\cr
Selected performance measure.
Default is first measure in scenario.}
}
\value{
[\code{data.frame}].
}
\description{
The first 2 columns are \dQuote{instance_id} and \dQuote{repetition}. The remaining ones are
the measured performance values.
The feature columns are in the same order as \dQuote{features_deterministic},
\dQuote{features_stochastic} in the description object.
code{NA} means the performance value is not available, possibly because the algorithm run was aborted.
The data.frame is sorted by \dQuote{instance_id}, then \dQuote{repetition}.
}
