% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shared_class_functions.r
\name{insert}
\alias{insert}
\title{Insert data}
\usage{
insert(
  x,
  vals,
  relations = names(x),
  all = FALSE,
  keep_rownames = FALSE,
  digits = getOption("digits"),
  ...
)
}
\arguments{
\item{x}{a relational data object, into which to insert data, such as a
\code{\link{relation}} or \code{\link{database}} object.}

\item{vals}{a data frame, containing data to insert. Column names must be
unique.}

\item{relations}{a character vector, containing names of elements of \code{x}
into which to insert data. By default, \code{insert} attempts to insert
data into every element.}

\item{all}{a logical, indicating whether \code{vals} is required to contain
all attributes of all elements of \code{x[relations]}. By default, it is
not, and data is only inserted into elements of \code{x[relations]} whose
attributes are all present in \code{vals}.}

\item{keep_rownames}{a logical or a string, indicating whether to include the
row names as a column. If a string is given, it is used as the name for the
column, otherwise the column is named "row". Set to FALSE by default.}

\item{digits}{a positive integer, indicating how many significant digits are
to be used for numeric and complex variables. A value of \code{NA} results
in no rounding. By default, this uses \code{getOption("digits")}, similarly
to \code{\link{format}}. See the "Floating-point variables" section for
\code{\link{discover}} for why this rounding is necessary for consistent
results across different machines. See the note in
\code{\link{print.default}} about \code{digits >= 16}.}

\item{...}{further arguments pass on to methods.}
}
\value{
An R object of the same class as \code{x}, containing the additional
new data.
}
\description{
Generic function for inserting a data frame of data into an object.
}
\details{
This function is intended for inserting into an object that is itself
comprised of data frames, such as a \code{\link{relation}} or a
\code{\link{database}}. The given methods have the following behaviour:
\itemize{
\item If an empty set of data is inserted, into a non-empty object element,
nothing happens.
\item If an empty set of data is inserted into an empty object element, the
resulting element is also empty, but takes on the attribute/column classes
of the inserted data. This is done to prevent having to know attribute
classes during object creation.
\item Insertion can fail if inserting would violate object constraints. For
example, databases cannot have data inserted that would violate
candidate/foreign key constraints.
\item For other cases, the data is inserted in an object element in the
same way as using \code{\link{rbind}}, followed by \code{\link{unique}}.
}

While key violations prevent insertion, re-insertion of existing records in
an object element does not. This makes insertion equivalent to an \code{INSERT OR
IGNORE} expression in SQL. In particular, it is somewhat like using this
expression in SQLite, since that implementation uses dynamic typing.

If \code{vals} contains attributes not included in
\code{\link{attrs_order}(x)}, \code{insert} throws an error, since those
attributes can't be inserted.

If a partial set of attributes is inserted, and \code{all} is \code{FALSE},
then data is only inserted into components of \code{x[relations]} whose
required attributes are all present in \code{vals}. If \code{all} is
\code{TRUE}, \code{insert} returns an error instead. This is useful when
specifying \code{relations}: in that case, you often intend to insert
into all of the specified elements, so not including all the required
attributes is a mistake, and \code{all = TRUE} prevents it.

If \code{all} is \code{TRUE}, \code{insert}
throws an error in this case: This ensures you insert into all members of a
specified value of \code{relations}.
}
