% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_layered.R
\name{layout_layered}
\alias{layout_layered}
\alias{layout_tbl_graph_layered}
\title{Layered layout}
\usage{
layout_tbl_graph_layered(.data, center = NULL, circular = FALSE, times = 4)
}
\arguments{
\item{.data}{Some \code{{manynet}} compatible network data.}

\item{center, circular}{Extra parameters required for \code{{tidygraph}}
compatibility.}

\item{times}{Integer of sweeps that the algorithm will pass through.
By default 4.}
}
\value{
Returns a table of coordinates.
}
\description{
Layered layout
}
\examples{
ties <- data.frame(
  from = c("A", "A", "B", "C", "D", "F", "F", "E"),
  to   = c("B", "C", "D", "E", "E", "E", "G", "G"),
  stringsAsFactors = FALSE)

coords <- layout_tbl_graph_layered(ties, times = 6)
coords
}
