% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-joensson.R
\encoding{UTF-8}
\name{model.joensson.customize}
\alias{model.joensson.customize}
\title{Customize the Jönsson model}
\arguments{
\item{dd_onset_start_date}{The date, when the degree days start to sum up ('MM-DD').}

\item{dd_onset_base}{Base temperature to calculate degree days to trigger the onset.}

\item{dd_onset_threshold}{Degree days that are required to trigger the onset of
infestation. Additionally, the maximum temperature must exceed \code{tfly}.}

\item{tfly}{Minimum temperature that beetles need to fly.}

\item{dd_development_base}{Base temperature to calculate degree days for development.}

\item{dd_total_dev_lower, dd_total_dev_upper}{Lower/upper limit of degree days
that are required for a generation to fully develop}

\item{dev_start, dev_end}{Share in total development when the egg development starts and the
juvenile beetle's development ends respectively. Usable if the development
below/above these thresholds should account for mating, oviposition etc.}

\item{dev_mortal_min, dev_mortal_max}{The beetles are considered to be in
white stages (egg, larva, pupa) if their development exceeds \code{dev_mortal_min}
and subceeds \code{dev_mortal_max}. During these stages, the beetles could die
due to a mortality event. \code{NULL} means that no lower/upper threshold is
defined.}

\item{model_end_date}{Date when the model ends (no further development will
be modeled).}

\item{daylength_dia, tdia_min}{When the daylength falls below \code{daylength_dia}
and the average daily temperature falls below \code{tdia_min}, diapause
will be initiated. The default value for the critical daylength was set to
19.3 hours according to \insertCite{Schroeder2017;textual}{barrks} who
examined the photoperiodic diapause induction in Sweden. If the model is used
for other regions, this value should be adjusted.}
}
\description{
This page describes the parameters
that can be used to customize the Jönsson model. The model was developed by
\insertCite{Jonsson2011;textual}{barrks}. Look \link[=model.joensson.apply]{here} to find
out how to apply the model.
}
\details{
In \code{barrks}, \code{\link[=model]{model()}} is used to customize a model. The following code
illustrates which parameters are available for the Jönsson model and specifies their
default values.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{model("joensson",

      # ==== onset ====

      dd_onset_start_date = '01-01',
      dd_onset_base = 5,
      dd_onset_threshold = 120,

      # ==== onset + development ====

      tfly = 20,

      # ==== development ====

      dd_development_base = 5,
      dd_total_dev_lower = 625,
      dd_total_dev_upper = 750,
      dev_start = 0,
      dev_end = 1,
      dev_mortal_min = 0,
      dev_mortal_max = 1,

      model_end_date = '12-31',

      # ==== diapause ====

      daylength_dia = 19.3,
      tdia_min = 15
)
}\if{html}{\out{</div>}}
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=model]{model()}}, \code{\link[=phenology]{phenology()}}, \code{\link{model.joensson.apply}}

Other model customizations: 
\code{\link{model.bso.customize}},
\code{\link{model.chapy.customize}},
\code{\link{model.lange.customize}},
\code{\link{model.phenips.customize}},
\code{\link{model.phenips_clim.customize}},
\code{\link{model.rity.customize}}
}
\concept{model customizations}
