# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @name distRcpp
#' @description calculate Euclidean distances between rows of matrix X
#' @title calculate Euclidean distances
#' @usage distRcpp(X)
#' @param X data matrix
#' @return distance matrix
#' @examples
#' x <- matrix(rnorm(100), nrow = 5)
#' distRcpp(x)
#' 
distRcpp <- function(X) {
    .Call('_bayMDS_distRcpp', PACKAGE = 'bayMDS', X)
}

#' @name bmdsMCMC
#' @description run MCMC algorithm given in Oh and Raftery (2001) and return  posterior samples of
#' parameters as well as
#'  object configuration and other parameter estimates, for a given number of dimensions p
#' @title MCMC for Bayesian multidimensional scaling  
#' @usage bmdsMCMC(DIST,p,nwarm = 1000,niter = 5000)
#' @param  DIST symmetric matrix of dissimilarity measures between objects  
#' @param p number of dimensions of object configuration 
#' @param nwarm number of iterations for  burn-in period in MCMC (default=1000)     
#' @param niter number of MCMC iterations after burn-in period (default=5000)
#' @return  A list of  MCMC results
#' \describe{
#'   \item{x_bmds}{n by p matrix of object configuration that minimizes the sum of squares of residuals(SSR),
#'   where n is the number of objects, i.e., n=nrow(DIST)}
#'   \item{cmds}{n by p matrix of object configuration from the classical multidimensional scaling of Togerson(1952)}
#'   \item{minSSR}{minimum of sum of squares of residuals between the observed dissimilarities and 
#'   the estimated Euclidean distances for pairs of objects}
#'   \item{minSSR_id}{index of the iteration corresponding to minimum SSR}
#'   \item{stress}{ STRESS computed from minSSR }
#'   \item{e_sigma}{ posterior mean of \eqn{\sigma^2}}
#'   \item{var_sigma}{ posterior variance of \eqn{\sigma^2}}
#'   \item{SSR.L}{niter dimensional vector of posterior samples of SSR}
#'   \item{lam.L}{niter by  p matrix of posterior samples of elements of \eqn{\Lambda}}
#'   \item{sigma.L}{niter dimensional vector of posterior samples of \eqn{\sigma^2} }
#'   \item{del.L}{niter by \eqn{n(n-1)/2} matrix of posterior samples of \eqn{\delta}, p-dimensional Euclidean distances 
#'   between pairs of objects}
#'   }
#' @references Oh, M-S., Raftery A.E. (2001). Bayesian Multidimensional Scaling and Choice of Dimension, 
#' Journal of the American Statistical Association, 96, 1031-1044.
#' @exportPattern "^[[:alpha:]]+"
#' @importFrom Rcpp evalCpp
#' @useDynLib bayMDS
#' @examples
#' \donttest{
#' data(cityDIST)
#' result=bmdsMCMC(cityDIST,p=3)
#' }
bmdsMCMC <- function(DIST, p, nwarm = 1000L, niter = 5000L) {
    .Call('_bayMDS_bmdsMCMC', PACKAGE = 'bayMDS', DIST, p, nwarm, niter)
}

