% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierarchy.R
\name{temporal_aggregation}
\alias{temporal_aggregation}
\title{Temporal aggregation of a time series}
\usage{
temporal_aggregation(y, agg_levels = NULL)
}
\arguments{
\item{y}{univariate time series of class \link[stats]{ts}.}

\item{agg_levels}{user-selected list of aggregation levels.}
}
\value{
A list of \link[stats]{ts} objects each containing the aggregates time series in the order defined by \code{agg_levels}.
}
\description{
Creates a list of aggregated time series from a time series of class \link[stats]{ts}.
}
\details{
If \code{agg_levels=NULL} then \code{agg_levels} is automatically generated by taking all the factors of the time series frequency.
}
\examples{

# Create a monthly count time series with 100 observations
y <- ts(data=stats::rpois(100,lambda = 2),frequency = 12)

# Create the aggregate time series according to agg_levels
y_agg <- temporal_aggregation(y,agg_levels = c(2,3,4,6,12))

# Show annual aggregate time series
print(y_agg$`f=1`)

}
\seealso{
\code{\link[=get_reconc_matrices]{get_reconc_matrices()}}
}
