% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructors.R
\name{LinearAbxAcquisitionParams}
\alias{LinearAbxAcquisitionParams}
\title{Linear Antibiotic Acquisition Parameters}
\usage{
LinearAbxAcquisitionParams(
  base = Param(0.001),
  time = Param(1, 0),
  mass = Param(1, 1),
  freq = Param(1, 1),
  col_abx = Param(1, 0),
  suss_abx = Param(1, 0),
  suss_ever = Param(1, 0)
)
}
\arguments{
\item{base}{The base rate of acquisition.}

\item{time}{The time effect on acquisition.}

\item{mass}{The mass action effect on acquisition.}

\item{freq}{The frequency effect on acquisition.}

\item{col_abx}{The effect for colonized on antibiotics.}

\item{suss_abx}{The effect on susceptible being currently on antibiotics.}

\item{suss_ever}{The effect on susceptible ever being on antibiotics.}
}
\value{
A list of parameters for acquisition.
}
\description{
Acquisition parameters for LinearAbxModel and LinearAbxModel2.
}
\details{
The model for this acquisition model is given by

\deqn{
P(\mathrm{Acq(t)}) =
    \left[e^{\beta_\mathrm{time}(t-t_0)}\right]\\
\left\{e^{\beta_0}
    \left[
        \left(
          \frac{\beta_\mathrm{freq}}{P(t)}+(1 - e^{\beta_\mathrm{freq}})
        \right)
        e^{\beta_\mathrm{mass}}\left(
            (N_c(t) - N_{ca}(t)) + e^{\beta_\mathrm{col\_abx}}N_{ca}(t)
            \right)
        + 1 - e^{\beta_\mathrm{mass}}
        \right]
    \right\}\\
 \left[
     N_S(t) - N_E(t) +
     e^{\beta_\mathrm{suss\_ever}}
     \left(
       \left(
         E_i(t) - A_i(t)
       \right)
       + A_i(t)e^{\beta_\mathrm{suss\_abx}}
     \right)
 \right]
}{
 P(Acq(t)) = exp(beta_time*(t-t0)) * {
   exp(beta_0) * [
     (beta_freq/P(t)
   + (1-exp(beta_freq))) * exp(beta_mass) * ((N_c(t) - N_ca(t)) + exp(beta_col_abx)*N_ca(t)) + 1 - exp(beta_mass)
   ]
 }
 * [
   N_S(t) - N_E(t) + exp(beta_suss_ever)*((E_i(t)-A_i(t)) + A_i(t)*exp(beta_suss_abx))
 ]
}
where P(Acq(t)) is the acquisition probability at time t, with effects from time (beta_time),
mass action (beta_mass), frequency dependence (beta_freq),
colonized individuals on antibiotics (beta_col_abx),
and susceptible individuals currently (beta_suss_abx) or ever (beta_suss_ever) on antibiotics.
}
\examples{
LinearAbxAcquisitionParams()
}
