% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hessian.R
\name{hessian}
\alias{hessian}
\title{Hessian matrix}
\usage{
hessian(lik, theta, ...)
}
\arguments{
\item{lik}{function}

\item{theta}{kx1 matrix}

\item{...}{other parameters passed to \code{lik} function.}
}
\value{
Hessian kxk matrix where k is the number of parameters
included in the theta matrix
}
\description{
Creates the hessian matrix for a given likelihood function.
}
\examples{
lik <- function(theta) {
 return(theta[1]^2 + theta[2]^2)
}

hessian(lik, c(1, 1))

}
