% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareDist.R
\name{compareDist}
\alias{compareDist}
\title{compare distributions}
\usage{
compareDist(
  df,
  plot = 1:4,
  bw = "SJ",
  col = catPal(ncol(df), alpha = 0.3),
  main = paste("Distributions of", deparse(substitute(df))),
  xlab = "Values",
  ylab = "Density",
  legpos1 = "topleft",
  legpos2 = NULL,
  horizontal = FALSE,
  ...
)
}
\arguments{
\item{df}{Data.frame with (named) columns.}

\item{plot}{Integers: which graphics to plot?\cr
Plot 1: overlaid density estimates\cr
Plot 2: multipanel histogram\cr
Plot 3: boxplot\cr
Plot 4: violin plot, if package \code{vioplot} is available.\cr
DEFAULT: 1:4}

\item{bw}{Bandwidth passed to \code{\link{density}} for plot 1. DEFAULT: "SJ"}

\item{col}{Color (vector). DEFAULT: \code{\link{catPal}(ncol(df), alpha=0.3)}}

\item{main}{Title. DEFAULT: "Distributions of [df name]"}

\item{xlab, ylab}{Axis labels for plot 1. DEFAULT: xlab="Values", ylab="Density"}

\item{legpos1, legpos2}{Legend position for plot 1. DEFAULT: "topleft", NULL}

\item{horizontal}{Should boxplot and vioplot (plot 3 and 4) be horizontal? DEFAULT: FALSE}

\item{\dots}{Further arguments passed to \code{\link{polygon}} (plot 1), 
\code{\link{groupHist}} (plot 2)
\code{\link{boxplot}} (plot 3) and 
\code{vioplot::\link[vioplot]{vioplot}} (plot 4)}
}
\value{
df, invisible
}
\description{
compare multiple distributions. All based on columns in a data.frame.
             Creates several plots based on the integers present in \code{plot}.
}
\examples{
fakedata <- data.frame(norm=rnorm(30), exp=rexp(30), unif=runif(30))
compareDist(fakedata)

}
\seealso{
\code{\link{groupHist}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Aug 2020
}
\keyword{hplot}
