% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional.betapart.core.pairwise.R
\name{qhull.opt}
\alias{qhull.opt}
\title{Specifying control Values for convexhull volume estimation}
\usage{
qhull.opt(conv1 = "QJ", conv2 = NULL)
}
\arguments{
\item{conv1}{A character vector specifying qhull options.}

\item{conv2}{A character vector specifying qhull options to use if the internal computation of convexhull volumes generates an error. By default (\code{NULL}) \code{NA} is returned.}
}
\value{
A named list of two elements.
}
\description{
Set the default value to use inside the \code{functional.betapart.core} and \code{functional.betapart.pairwise} functions. 
It defined the options to use with the \code{convhulln} fonction.
}
\details{
\code{conv1} defined options that will be use systematically when calling convhulln to estimate the convexhull volume of the intersection, while
\code{conv2} whill be used only if the first call to convhulln would have generated an error. For the complete list of possible options see For the list of options see  \url{http://www.qhull.org/html/qh-optq.htm}. 
By default, no option are passed which would generates \code{NA} if internal error. Setting one of the two elements to "QJ" can solve different issues 
with very close numerical estimation (difference lower than 1e-4 in our tests).
}
\examples{
\dontrun{qhull.opt()
qhull.opt(conv1 = 'QJ')
qhull.opt(conv1 = "Qt", conv2 = 'QJ')}
}
\seealso{
\code{\link{inter_rcdd}}, \code{\link{inter_geom}}, \code{\link{convhulln}}.
}
