% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bi_class.R
\name{bi_class_breaks}
\alias{bi_class_breaks}
\title{Return Breaks}
\usage{
bi_class_breaks(.data, x, y, style, dim = 3, clean_levels = TRUE,
    dig_lab = 3, split = FALSE)
}
\arguments{
\item{.data}{A data frame, tibble, or \code{sf} object}

\item{x}{The \code{x} variable, either a numeric (including double and integer
classes) or factor}

\item{y}{The \code{y} variable, either a numeric (including double and integer
classes) or factor}

\item{style}{A string identifying the style used to calculate breaks. Currently
supported styles are \code{"quantile"} (default), \code{"equal"}, \code{"fisher"},
and \code{"jenks"}. If both \code{x} and \code{y} are factors, this argument can
be omitted.}

\item{dim}{The dimensions of the palette. To use the built-in palettes,
    this value must be either \code{2}, \code{3}, or \code{4}. A value of
    \code{3}, for example, would be used to create a three-by-three bivariate
    map with a total of 9 classes.

    If you are using a custom palette, this value may be larger (though these
    maps can be very hard to interpret).

    If you are using pre-made factors, both factors must have the same number
    of levels as this value.}

\item{clean_levels}{A logical scalar; if \code{TRUE} (default), the
brackets and parentheses will be stripped from the output. If \code{FALSE}
(default), the levels will be returned with brackets and parentheses. If
\code{split} is \code{TRUE} and \code{clean_levels} is \code{FALSE},
the \code{clean_levels} argument will be overridden.}

\item{dig_lab}{An integer that is passed to \code{base::cut()}; it determines
the number of digits used in formatting break numbers. It can either be
a scalar or a vector. If it is a scalar, the value will be applied to both
the \code{x} and \code{y} variables. If it is a vector, the first element
will be applied to the \code{x} variable and the second will be applied
to the \code{y} variable.}

\item{split}{A logical scalar; if \code{FALSE} (default), the range of values
for each factor level (corresponds to \code{dim}) will be returned for
both the \code{x} and \code{y} variables. If \code{TRUE}, the individual
values for each break (including the minimum and maximum values) will be
returned.}
}
\value{
A list where \code{bi_x} is a vector containing the breaks for the
    \code{x} variable and \code{bi_y} is a vector containing the breaks for
    the \code{y} variable.
}
\description{
This function can be used to return a list containing vectors
    of either the ranges of values included in each category of \code{x}
    and \code{y} or, alternatively, the individual break values including
    the minimum and maximum values. This function supports simplified
    reporting as well as more descriptive legends.
}
\examples{
# return ranges for each category of x and y
bi_class_breaks(stl_race_income, style = "quantile", x = pctWhite, y = medInc,
    dim = 4, dig_lab = c(4, 5), split = FALSE)

# ranges can be returned with brackets and parentheses
bi_class_breaks(stl_race_income, style = "quantile", x = pctWhite, y = medInc,
    clean_levels = FALSE, dim = 4, dig_lab = 3, split = FALSE)

# return breaks for each category of x and y
bi_class_breaks(stl_race_income, style = "quantile", x = pctWhite, y = medInc,
    dim = 4, dig_lab = c(4, 5), split = TRUE)

# optionally name vector for dig_lab for increased clarity of code
bi_class_breaks(stl_race_income, style = "quantile", x = pctWhite, y = medInc,
    dim = 4, dig_lab = c(x = 4, y = 5), split = TRUE)

# scalars can also be used for dig_lab, though results may be less optimal
bi_class_breaks(stl_race_income, style = "quantile", x = pctWhite, y = medInc,
    dim = 4, dig_lab = 3, split = TRUE)

}
