% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bessel_functions.R
\name{bessel_functions}
\alias{bessel_functions}
\alias{cyl_bessel_j}
\alias{cyl_neumann}
\alias{cyl_bessel_j_zero}
\alias{cyl_neumann_zero}
\alias{cyl_bessel_i}
\alias{cyl_bessel_k}
\alias{sph_bessel}
\alias{sph_neumann}
\alias{cyl_bessel_j_prime}
\alias{cyl_neumann_prime}
\alias{cyl_bessel_i_prime}
\alias{cyl_bessel_k_prime}
\alias{sph_bessel_prime}
\alias{sph_neumann_prime}
\title{Bessel Functions, Their Derivatives, and Zeros}
\usage{
cyl_bessel_j(v, x)

cyl_neumann(v, x)

cyl_bessel_j_zero(v, m = NULL, start_index = NULL, number_of_zeros = NULL)

cyl_neumann_zero(v, m = NULL, start_index = NULL, number_of_zeros = NULL)

cyl_bessel_i(v, x)

cyl_bessel_k(v, x)

sph_bessel(v, x)

sph_neumann(v, x)

cyl_bessel_j_prime(v, x)

cyl_neumann_prime(v, x)

cyl_bessel_i_prime(v, x)

cyl_bessel_k_prime(v, x)

sph_bessel_prime(v, x)

sph_neumann_prime(v, x)
}
\arguments{
\item{v}{Order of the Bessel function}

\item{x}{Argument of the Bessel function}

\item{m}{The index of the zero to find (1-based).}

\item{start_index}{The starting index for the zeros (1-based).}

\item{number_of_zeros}{The number of zeros to find.}
}
\value{
Single numeric value for the Bessel functions and their derivatives, or a vector of length \code{number_of_zeros} for the multiple zero functions.
}
\description{
Functions to compute Bessel functions of the first and second kind, their modified versions, spherical Bessel functions, and their derivatives and zeros.
}
\examples{
# Bessel function of the first kind J_0(1)
cyl_bessel_j(0, 1)
# Bessel function of the second kind Y_0(1)
cyl_neumann(0, 1)
# Modified Bessel function of the first kind I_0(1)
cyl_bessel_i(0, 1)
# Modified Bessel function of the second kind K_0(1)
cyl_bessel_k(0, 1)
# Spherical Bessel function of the first kind j_0(1)
sph_bessel(0, 1)
# Spherical Bessel function of the second kind y_0(1)
sph_neumann(0, 1)
# Derivative of the Bessel function of the first kind J_0(1)
cyl_bessel_j_prime(0, 1)
# Derivative of the Bessel function of the second kind Y_0(1)
cyl_neumann_prime(0, 1)
# Derivative of the modified Bessel function of the first kind I_0(1)
cyl_bessel_i_prime(0, 1)
# Derivative of the modified Bessel function of the second kind K_0(1)
cyl_bessel_k_prime(0, 1)
# Derivative of the spherical Bessel function of the first kind j_0(1)
sph_bessel_prime(0, 1)
# Derivative of the spherical Bessel function of the second kind y_0(1)
sph_neumann_prime(0, 1)
# Finding the first zero of the Bessel function of the first kind J_0
cyl_bessel_j_zero(0, 1)
# Finding the first zero of the Bessel function of the second kind Y_0
cyl_neumann_zero(0, 1)
# Finding multiple zeros of the Bessel function of the first kind J_0 starting from index 1
cyl_bessel_j_zero(0, start_index = 1, number_of_zeros = 5)
# Finding multiple zeros of the Bessel function of the second kind Y_0 starting from index 1
cyl_neumann_zero(0, start_index = 1, number_of_zeros = 5)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/bessel.html}{Boost Documentation} for more details on the mathematical background.
}
